/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.load.registration;

import com.google.common.collect.ImmutableListMultimap;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.ListMultiMap;
import net.minecraft.resources.ResourceLocation;

public class RecipeCatalystRegistration
implements IRecipeCatalystRegistration {
    private final ListMultiMap<ResourceLocation, ITypedIngredient<?>> recipeCatalysts = new ListMultiMap();
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientManager ingredientManager;

    public RecipeCatalystRegistration(RegisteredIngredients registeredIngredients, IIngredientManager ingredientManager) {
        this.registeredIngredients = registeredIngredients;
        this.ingredientManager = ingredientManager;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public <T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T ingredient, RecipeType<?> ... recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        for (RecipeType<?> recipeType : recipeTypes) {
            ErrorUtil.checkNotNull(recipeType, "recipeType");
            ITypedIngredient<T> typedIngredient = TypedIngredient.createTyped(this.registeredIngredients, ingredientType, ingredient).orElseThrow(() -> new IllegalArgumentException("Recipe catalyst must not be empty"));
            this.recipeCatalysts.put((Object)recipeType.getUid(), typedIngredient);
        }
    }

    public ImmutableListMultimap<ResourceLocation, ITypedIngredient<?>> getRecipeCatalysts() {
        return this.recipeCatalysts.toImmutable();
    }
}

