/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.focus.FocusGroup;
import mezz.jei.common.gui.GuiProperties;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.elements.GuiIconButtonSmall;
import mezz.jei.common.gui.ingredients.RecipeSlot;
import mezz.jei.common.gui.recipes.IRecipeGuiLogic;
import mezz.jei.common.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.common.gui.recipes.RecipeCatalysts;
import mezz.jei.common.gui.recipes.RecipeGuiLogic;
import mezz.jei.common.gui.recipes.RecipeGuiTabs;
import mezz.jei.common.gui.recipes.layout.RecipeLayout;
import mezz.jei.common.gui.recipes.layout.RecipeTransferButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.ClickedIngredient;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.MouseUtil;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.recipes.RecipeManager;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends Screen
implements IRecipesGui,
IRecipeFocusSource,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final RecipeTransferManager recipeTransferManager;
    private final RegisteredIngredients registeredIngredients;
    private final IModIdHelper modIdHelper;
    private final IClientConfig clientConfig;
    private final IInternalKeyMappings keyBindings;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private Component title = CommonComponents.EMPTY;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final HoverChecker titleHoverChecker = new HoverChecker();
    private final List<RecipeTransferButton> recipeTransferButtons;
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
    private boolean init = false;

    public RecipesGui(RecipeManager recipeManager, RecipeTransferManager recipeTransferManager, RegisteredIngredients registeredIngredients, IModIdHelper modIdHelper, IClientConfig clientConfig, Textures textures, IIngredientVisibility ingredientVisibility, IInternalKeyMappings keyBindings) {
        super((Component)Component.literal((String)"Recipes"));
        this.recipeTransferButtons = new ArrayList<RecipeTransferButton>();
        this.recipeTransferManager = recipeTransferManager;
        this.registeredIngredients = registeredIngredients;
        this.modIdHelper = modIdHelper;
        this.clientConfig = clientConfig;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, registeredIngredients, modIdHelper, textures, ingredientVisibility);
        this.recipeCatalysts = new RecipeCatalysts(textures, ingredientVisibility);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, textures);
        this.minecraft = Minecraft.getInstance();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.logic.nextRecipeCategory(), textures);
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.logic.previousRecipeCategory(), textures);
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.logic.nextPage(), textures);
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.logic.previousPage(), textures);
        this.background = textures.getRecipeGuiBackground();
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        font.drawShadow(poseStack, string, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, Component text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (FormattedText)text);
        font.drawShadow(poseStack, text, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        int xSize = 198;
        int ySize = this.height - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.width - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.font);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.x = rightButtonX;
        this.nextRecipeCategory.y = recipeClassButtonTop;
        this.previousRecipeCategory.x = leftButtonX;
        this.previousRecipeCategory.y = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.x = rightButtonX;
        this.nextPage.y = pageButtonTop;
        this.previousPage.x = leftButtonX;
        this.previousPage.y = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.getWidth() + 14).cropRight(this.nextRecipeCategory.getWidth() + 14);
        this.addRenderableWidget((GuiEventListener)this.nextRecipeCategory);
        this.addRenderableWidget((GuiEventListener)this.previousRecipeCategory);
        this.addRenderableWidget((GuiEventListener)this.nextPage);
        this.addRenderableWidget((GuiEventListener)this.previousPage);
        this.init = true;
        this.updateLayout();
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderBackground(poseStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        this.background.draw(poseStack, x, y, width, height);
        RenderSystem.disableBlend();
        RecipesGui.fill((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.y, (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.y + 13), (int)0x30000000);
        RecipesGui.fill((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.y, (int)(x + width - 6 - 13), (int)(this.nextPage.y + 13), (int)0x30000000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.font, this.title, this.titleArea);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.font, this.pageString, pageArea);
        this.nextRecipeCategory.render(poseStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.render(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.render(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.render(poseStack, mouseX, mouseY, partialTicks);
        RecipeLayout<?> hoveredLayout = null;
        for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(poseStack, mouseX, mouseY);
        }
        RecipeSlot hoveredRecipeCatalyst = this.recipeCatalysts.draw(poseStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.minecraft, poseStack, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(poseStack, mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(poseStack, 0, 0, mouseX, mouseY, this.modIdHelper);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            MutableComponent showAllRecipesString = Component.translatable((String)"jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(poseStack, List.of(showAllRecipesString), mouseX, mouseY);
        }
    }

    public void tick() {
        super.tick();
        Optional.ofNullable(this.minecraft).map(minecraft -> minecraft.player).ifPresent(localPlayer -> {
            AbstractContainerMenu container = this.getParentContainer();
            for (RecipeTransferButton button : this.recipeTransferButtons) {
                button.update(this.recipeTransferManager, container, (Player)localPlayer);
            }
        });
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.minecraft != null && this.minecraft.screen == this) {
            if (this.area.contains(mouseX, mouseY)) {
                return true;
            }
            for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    private Stream<IClickedIngredient<?>> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayouts.stream().map(recipeLayout -> RecipesGui.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickedIngredient<?>> getRecipeLayoutIngredientUnderMouse(RecipeLayout<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipesGui.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickedIngredient<?>> getClickedIngredient(RecipeLayout<?> recipeLayout, RecipeSlot recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipesGui.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            return new ClickedIngredient(displayedIngredient, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(RecipeLayout<?> recipeLayout, ImmutableRect2i area) {
        return area.addOffset(recipeLayout.getPosX(), recipeLayout.getPosY());
    }

    public boolean mouseScrolled(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.isMouseOver(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.mouseScrolled(scrollX, scrollY, scrollDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IUserInputHandler handler;
        double mouseY;
        double mouseX = input.getMouseX();
        if (this.isMouseOver(mouseX, mouseY = input.getMouseY())) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (input.is(this.keyBindings.getLeftClick()) && this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleInput(input, this.keyBindings)) continue;
                    return true;
                }
            }
        }
        if ((handler = this.recipeGuiTabs.getInputHandler()).handleUserInput(this, input, this.keyBindings).isPresent()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (input.is(this.keyBindings.getCloseRecipeGui()) || input.is(minecraft.options.keyInventory)) {
            this.onClose();
            return true;
        }
        if (input.is(this.keyBindings.getRecipeBack())) {
            this.back();
            return true;
        }
        if (input.is(this.keyBindings.getNextCategory())) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousCategory())) {
            this.logic.previousRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getNextRecipePage())) {
            this.logic.nextPage();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousRecipePage())) {
            this.logic.previousPage();
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.minecraft != null && this.minecraft.screen == this;
    }

    private void open() {
        if (this.minecraft != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.minecraft.screen;
            }
            this.minecraft.setScreen((Screen)this);
        }
    }

    public void onClose() {
        if (this.isOpen() && this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.onClose();
    }

    public <V> void show(IFocus<V> focus) {
        IFocusGroup checkedFocuses = FocusGroup.create(focus, this.registeredIngredients);
        if (this.logic.setFocus(checkedFocuses)) {
            this.open();
        }
    }

    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = FocusGroup.create(focuses, this.registeredIngredients);
        if (this.logic.setFocus(checkedFocuses)) {
            this.open();
        }
    }

    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.setCategoryFocus(recipeTypes)) {
            this.open();
        }
    }

    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickedIngredient::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeBackground.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = x + (width - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.font.width((FormattedText)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.font);
        }
        ImmutableRect2i titleStringArea = MathUtil.centerTextArea(this.titleArea, this.font, (FormattedText)this.title);
        this.titleHoverChecker.updateBounds(titleStringArea);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, y + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.active = this.previousPage.active = this.logic.hasMultiplePages();
        this.nextRecipeCategory.active = this.previousRecipeCategory.active = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ITypedIngredient<?>> recipeCatalysts = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalysts, this);
        this.recipeGuiTabs.initLayout(this);
    }

    private void addRecipeTransferButtons(List<RecipeLayout<?>> recipeLayouts) {
        if (this.minecraft == null) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        for (GuiEventListener guiEventListener : this.recipeTransferButtons) {
            this.removeWidget(guiEventListener);
        }
        this.recipeTransferButtons.clear();
        AbstractContainerMenu container = this.getParentContainer();
        for (RecipeLayout<?> recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.update(this.recipeTransferManager, container, (Player)player);
            button.setOnClickHandler((arg_0, arg_1) -> this.lambda$addRecipeTransferButtons$10(container, recipeLayout, (Player)player, arg_0, arg_1));
            this.addRenderableWidget((GuiEventListener)button);
            this.recipeTransferButtons.add(button);
        }
    }

    @Nullable
    private AbstractContainerMenu getParentContainer() {
        Screen screen = this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            return screen2.getMenu();
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        int extraWidth = this.getRecipeCatalystExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.width, this.height);
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$10(AbstractContainerMenu container, RecipeLayout recipeLayout, Player player, double mouseX, double mouseY) {
        boolean maxTransfer = Screen.hasShiftDown();
        if (container != null && RecipeTransferUtil.transferRecipe(this.recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
            this.onClose();
        }
    }
}

