/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.jei.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class DebugIngredientRenderer
implements IIngredientRenderer<DebugIngredient> {
    private final IIngredientHelper<DebugIngredient> ingredientHelper;

    public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    public void render(PoseStack poseStack, DebugIngredient ingredient) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = this.getFontRenderer(minecraft, ingredient);
        font.draw(poseStack, "JEI", 0.0f, 0.0f, -65536);
        font.draw(poseStack, "#" + ingredient.getNumber(), 0.0f, 8.0f, -65536);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render(PoseStack stack, int xPosition, int yPosition, @Nullable DebugIngredient ingredient) {
        if (ingredient != null) {
            stack.pushPose();
            stack.translate((double)xPosition, (double)yPosition, 0.0);
            this.render(stack, ingredient);
            stack.popPose();
        }
    }

    public List<Component> getTooltip(DebugIngredient ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String displayName = this.ingredientHelper.getDisplayName((Object)ingredient);
        tooltip.add((Component)new TextComponent(displayName));
        TextComponent debugIngredient = new TextComponent("debug ingredient");
        tooltip.add((Component)debugIngredient.withStyle(ChatFormatting.GRAY));
        return tooltip;
    }
}

