/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.common.filter.IFilterTextSource;
import mezz.jei.common.gui.GuiProperties;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.ghost.GhostIngredientDragManager;
import mezz.jei.common.gui.overlay.ConfigButton;
import mezz.jei.common.gui.overlay.IIngredientGridSource;
import mezz.jei.common.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.GuiTextFieldFilter;
import mezz.jei.common.input.ICharTypedHandler;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.MouseUtil;
import mezz.jei.common.input.handlers.CheatInputHandler;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.common.input.handlers.NullInputHandler;
import mezz.jei.common.input.handlers.ProxyInputHandler;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public class IngredientListOverlay
implements IIngredientListOverlay,
IRecipeFocusSource,
ICharTypedHandler {
    private static final int BORDER_MARGIN = 6;
    private static final int INNER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final IConnectionToServer connectionToServer;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter textFieldFilter;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private ImmutableRect2i displayArea = ImmutableRect2i.EMPTY;
    private boolean hasRoom;
    @Nullable
    private IGuiProperties guiProperties;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IFilterTextSource filterTextSource, RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig, IConnectionToServer connectionToServer, Textures textures, IKeyBindings keyBindings) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.connectionToServer = connectionToServer;
        this.textFieldFilter = new GuiTextFieldFilter(textures);
        this.textFieldFilter.setValue(filterTextSource.getFilterText());
        this.textFieldFilter.setFocused(false);
        this.textFieldFilter.setResponder(filterTextSource::setFilterText);
        filterTextSource.addListener(this.textFieldFilter::setValue);
        ingredientGridSource.addSourceListChangedListener(() -> this.updateBounds(true));
        this.configButton = ConfigButton.create(this::isListDisplayed, worldConfig, textures, keyBindings);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, registeredIngredients, worldConfig);
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static ImmutableRect2i createDisplayArea(IGuiProperties guiProperties) {
        ImmutableRect2i screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        return screenRectangle.cropLeft(guiRight).insetBy(6);
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean exclusionAreasChanged) {
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.textFieldFilter.setFocused(false);
                this.ghostIngredientDragManager.stopDrag();
            }
        } else {
            boolean guiPropertiesChanged;
            boolean bl = guiPropertiesChanged = this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties);
            if (exclusionAreasChanged || guiPropertiesChanged) {
                this.updateNewScreen(guiProperties, guiPropertiesChanged);
            }
        }
    }

    private void updateNewScreen(IGuiProperties guiProperties, boolean guiPropertiesChanged) {
        this.guiProperties = guiProperties;
        this.displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
        if (guiPropertiesChanged) {
            this.ghostIngredientDragManager.stopDrag();
        }
        this.updateBounds(false);
    }

    private void updateBounds(boolean resetToFirstPage) {
        if (this.guiProperties == null) {
            return;
        }
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, this.guiProperties);
        ImmutableRect2i availableContentsArea = this.getAvailableContentsArea(searchBarCentered);
        Set<ImmutableRect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
        this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        ImmutableRect2i searchAndConfigArea = this.getSearchAndConfigArea(searchBarCentered, this.guiProperties);
        ImmutableRect2i searchArea = searchAndConfigArea.cropRight(20);
        ImmutableRect2i configButtonArea = searchAndConfigArea.keepRight(20);
        int searchTextColor = this.contents.isEmpty() ? -65536 : -1;
        this.textFieldFilter.setTextColor(searchTextColor);
        this.textFieldFilter.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
        if (this.hasRoom) {
            this.contents.updateLayout(resetToFirstPage);
        }
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private ImmutableRect2i getAvailableContentsArea(boolean searchBarCentered) {
        if (searchBarCentered) {
            return this.displayArea;
        }
        return this.displayArea.cropBottom(22);
    }

    private ImmutableRect2i getSearchAndConfigArea(boolean searchBarCentered, IGuiProperties guiProperties) {
        if (searchBarCentered) {
            ImmutableRect2i guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            return this.displayArea.keepBottom(20).matchWidthAndX(guiRectangle);
        }
        if (this.hasRoom) {
            ImmutableRect2i contentsArea = this.contents.getBackgroundArea();
            return this.displayArea.keepBottom(20).matchWidthAndX(contentsArea);
        }
        return this.displayArea.keepBottom(20);
    }

    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.textFieldFilter.renderButton(poseStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.guiProperties != null) {
            this.configButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.ghostIngredientDragManager.drawTooltips(minecraft, poseStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            this.configButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, AbstractContainerScreen<?> gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            poseStack.pushPose();
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            poseStack.translate((double)(-screenHelper.getGuiLeft(gui)), (double)(-screenHelper.getGuiTop(gui)), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, poseStack, mouseX, mouseY);
            poseStack.popPose();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.textFieldFilter.tick();
        }
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    public IUserInputHandler createInputHandler() {
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler(this.ghostIngredientDragManager.createInputHandler(), this.textFieldFilter.createInputHandler(), this.configButton.createInputHandler(), this.contents.createInputHandler(), new CheatInputHandler(this.contents, this.worldConfig, this.clientConfig, this.connectionToServer));
        IUserInputHandler hiddenInputHandler = this.configButton.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.guiProperties == null) {
                return NullInputHandler.INSTANCE;
            }
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            return hiddenInputHandler;
        });
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.textFieldFilter.isFocused();
    }

    @Override
    public boolean onCharTyped(char codePoint, int modifiers) {
        return this.textFieldFilter.charTyped(codePoint, modifiers);
    }

    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickedIngredient::getTypedIngredient).findFirst();
        }
        return Optional.empty();
    }

    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickedIngredient::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).findFirst().orElse(null);
        }
        return null;
    }

    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getVisibleIngredients(ingredientType).toList();
        }
        return Collections.emptyList();
    }
}

