/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.common.color.ColorGetter;
import mezz.jei.common.color.ColorName;
import mezz.jei.common.color.ColorNamer;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.ColorNameSerializer;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IngredientSortStage;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    @Nullable
    private static IClientConfig instance;
    private final Supplier<Boolean> debugModeEnabled;
    private final Supplier<Boolean> centerSearchBarEnabled;
    private final Supplier<Boolean> lowMemorySlowSearchEnabled;
    private final Supplier<Boolean> cheatToHotbarUsingHotkeysEnabled;
    private final Supplier<GiveMode> giveMode;
    private final Supplier<Integer> maxRecipeGuiHeight;
    private final Supplier<List<IngredientSortStage>> ingredientSorterStages;

    public ClientConfig(ConfigSchemaBuilder schema) {
        instance = this;
        ConfigCategoryBuilder advanced = schema.addCategory("advanced");
        this.debugModeEnabled = advanced.addBoolean("DebugMode", false, "Debug mode enabled");
        this.centerSearchBarEnabled = advanced.addBoolean("CenterSearch", false, "Display search bar in the center");
        this.lowMemorySlowSearchEnabled = advanced.addBoolean("LowMemorySlowSearchEnabled", false, "Set low-memory mode (makes search very slow, but uses less RAM)");
        this.cheatToHotbarUsingHotkeysEnabled = advanced.addBoolean("CheatToHotbarUsingHotkeysEnabled", false, "Enable cheating items into the hotbar by using the shift+number keys.");
        this.giveMode = advanced.addEnum("GiveMode", GiveMode.defaultGiveMode, "How items should be handed to you");
        this.maxRecipeGuiHeight = advanced.addInteger("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE, "Max. recipe gui height");
        ConfigCategoryBuilder colors = schema.addCategory("colors");
        Supplier<List<ColorName>> searchColors = colors.addList("SearchColors", ColorGetter.getColorDefaults(), ColorNameSerializer.INSTANCE, "Color values to search for");
        ColorNamer.create(searchColors);
        ConfigCategoryBuilder sorting = schema.addCategory("sorting");
        this.ingredientSorterStages = sorting.addList("IngredientSortStages", IngredientSortStage.defaultStages, new EnumSerializer<IngredientSortStage>(IngredientSortStage.class), "Sorting order for the ingredient list");
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled.get();
    }

    public boolean isCenterSearchBarEnabled() {
        return this.centerSearchBarEnabled.get();
    }

    public boolean isLowMemorySlowSearchEnabled() {
        return this.lowMemorySlowSearchEnabled.get();
    }

    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    public GiveMode getGiveMode() {
        return this.giveMode.get();
    }

    public int getMaxRecipeGuiHeight() {
        return this.maxRecipeGuiHeight.get();
    }

    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages.get();
    }
}

