/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BasicRecipeTransferInfo<C extends AbstractContainerMenu, R>
implements IRecipeTransferInfo<C, R> {
    private final Class<C> containerClass;
    private final RecipeType<R> recipeType;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BasicRecipeTransferInfo(Class<C> containerClass, RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.recipeType = recipeType;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    public Class<R> getRecipeClass() {
        Class cast = this.recipeType.getRecipeClass();
        return cast;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.recipeType.getUid();
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public boolean canHandle(C container, R recipe) {
        return true;
    }

    public List<Slot> getRecipeSlots(C container, R recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }

    public List<Slot> getInventorySlots(C container, R recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }
}

