/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import java.util.List;
import mezz.jei.common.input.ICharTypedHandler;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;

public class ClientInputHandler {
    private final List<ICharTypedHandler> charTypedHandlers;
    private final CombinedInputHandler inputHandler;
    private final IInternalKeyMappings keybindings;
    private final ReflectionUtil reflectionUtil = new ReflectionUtil();

    public ClientInputHandler(List<ICharTypedHandler> charTypedHandlers, CombinedInputHandler inputHandler, IInternalKeyMappings keybindings) {
        this.charTypedHandlers = charTypedHandlers;
        this.inputHandler = inputHandler;
        this.keybindings = keybindings;
    }

    public void onInitGui() {
        this.inputHandler.handleGuiChange();
    }

    public boolean onKeyboardKeyPressedPre(Screen screen, UserInput input) {
        if (!this.isContainerTextFieldFocused(screen)) {
            return this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        }
        return false;
    }

    public boolean onKeyboardKeyPressedPost(Screen screen, UserInput input) {
        if (this.isContainerTextFieldFocused(screen)) {
            return this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        }
        return false;
    }

    public boolean onKeyboardCharTypedPre(Screen screen, char codePoint, int modifiers) {
        if (!this.isContainerTextFieldFocused(screen)) {
            return this.handleCharTyped(codePoint, modifiers);
        }
        return false;
    }

    public boolean onKeyboardCharTypedPost(Screen screen, char codePoint, int modifiers) {
        if (this.isContainerTextFieldFocused(screen)) {
            return this.handleCharTyped(codePoint, modifiers);
        }
        return false;
    }

    public boolean onGuiMouseClicked(Screen screen, UserInput input) {
        boolean handled = this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        if (Minecraft.getInstance().screen == screen && input.is(this.keybindings.getLeftClick())) {
            handled |= this.inputHandler.handleDragStart(screen, input).isPresent();
        }
        return handled;
    }

    public boolean onGuiMouseReleased(Screen screen, UserInput input) {
        boolean handled = this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        if (input.is(this.keybindings.getLeftClick())) {
            handled |= this.inputHandler.handleDragComplete(screen, input).isPresent();
        }
        return handled;
    }

    public boolean onGuiMouseScroll(double mouseX, double mouseY, double scrollDelta) {
        return this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.charTypedHandlers.stream().filter(ICharTypedHandler::hasKeyboardFocus).anyMatch(handler -> handler.onCharTyped(codePoint, modifiers));
    }

    private boolean isContainerTextFieldFocused(Screen screen) {
        return this.reflectionUtil.getFieldWithClass((Object)screen, EditBox.class).anyMatch(textField -> textField.isActive() && textField.isFocused());
    }
}

