/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.helpers;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public final class ModIdHelper
implements IModIdHelper {
    private final IClientConfig config;
    private final IModIdFormatConfig modIdFormattingConfig;

    public ModIdHelper(IClientConfig config, IModIdFormatConfig modIdFormattingConfig) {
        this.config = config;
        this.modIdFormattingConfig = modIdFormattingConfig;
    }

    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (this.config.isDebugModeEnabled() && Minecraft.getInstance().options.advancedItemTooltips) {
            tooltip = ModIdHelper.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
        tooltipCopy.add((Component)Component.literal((String)modName));
        return tooltipCopy;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.stripFormatting((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    private static <T> List<Component> addDebugInfo(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<Component>(tooltip);
        MutableComponent jeiDebug = Component.literal((String)"JEI Debug:");
        MutableComponent info = Component.literal((String)("info: " + ingredientHelper.getErrorInfo(ingredient)));
        MutableComponent uid = Component.literal((String)("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient)));
        tooltip.add((Component)jeiDebug.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)info.withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)uid.withStyle(ChatFormatting.DARK_GRAY));
        return tooltip;
    }

    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

