/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.collect.ImmutableTable;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferManager {
    private final ImmutableTable<Class<? extends AbstractContainerMenu>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers;

    public RecipeTransferManager(ImmutableTable<Class<? extends AbstractContainerMenu>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers) {
        this.recipeTransferHandlers = recipeTransferHandlers;
    }

    @Nullable
    public <C extends AbstractContainerMenu, R> IRecipeTransferHandler<C, R> getRecipeTransferHandler(C container, IRecipeCategory<R> recipeCategory) {
        MenuType menuType;
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        try {
            MenuType cast;
            menuType = cast = container.getType();
        }
        catch (UnsupportedOperationException ignored) {
            menuType = null;
        }
        RecipeType recipeType = recipeCategory.getRecipeType();
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler<?, R> handler = this.getHandler(containerClass, menuType, recipeType);
        if (handler != null) {
            return handler;
        }
        return this.getHandler(containerClass, menuType, Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE);
    }

    @Nullable
    private <C extends AbstractContainerMenu, R> IRecipeTransferHandler<C, R> getHandler(Class<? extends C> containerClass, @Nullable MenuType<C> menuType, RecipeType<?> recipeType) {
        Optional handlerMenuType;
        IRecipeTransferHandler handler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, recipeType);
        if (handler != null && ((handlerMenuType = handler.getMenuType()).isEmpty() || ((MenuType)handlerMenuType.get()).equals(menuType))) {
            IRecipeTransferHandler cast = handler;
            return cast;
        }
        return null;
    }
}

