/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketGiveItemStack;
import mezz.jei.common.network.packets.PacketSetHotbarItemStack;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.GiveAmount;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_481;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;

    public CommandUtil(IClientConfig clientConfig, IConnectionToServer serverConnection) {
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
    }

    public void giveStack(class_1799 itemStack, GiveAmount giveAmount) {
        GiveMode giveMode = this.clientConfig.getGiveMode();
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        int amount = giveAmount.getAmountForStack(itemStack);
        if (minecraft.field_1755 instanceof class_481 && giveMode == GiveMode.MOUSE_PICKUP) {
            class_1799 sendStack = CommandUtil.copyWithSize(itemStack, amount);
            ServerCommandUtil.mousePickupItemStack((class_1657)player, sendStack);
        } else if (this.serverConnection.isJeiOnServer()) {
            class_1799 sendStack = CommandUtil.copyWithSize(itemStack, amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            this.serverConnection.sendPacketToServer(packet);
        } else {
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public void setHotbarStack(class_1799 itemStack, int hotbarSlot) {
        if (this.serverConnection.isJeiOnServer()) {
            class_1799 sendStack = CommandUtil.copyWithSize(itemStack, itemStack.method_7914());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            this.serverConnection.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(class_1799 itemStack, int amount) {
        if (itemStack.method_7960()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        class_1792 item = itemStack.method_7909();
        IPlatformRegistry<class_1792> itemRegistry = Services.PLATFORM.getRegistry(class_2378.field_25108);
        class_2960 itemResourceLocation = itemRegistry.getRegistryName(item);
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        class_746 sender = class_310.method_1551().field_1724;
        if (sender != null && sender.method_7337()) {
            CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
        }
    }

    private static void sendCreativeInventoryActions(class_746 sender, class_1799 stack, int amount) {
        for (int i = 0; i < sender.method_31548().field_7547.size() && amount > 0; ++i) {
            class_1799 currentStack = (class_1799)sender.method_31548().field_7547.get(i);
            if (currentStack.method_7960()) {
                class_1799 sendAllRemaining = CommandUtil.copyWithSize(stack, amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.method_7962(stack) || currentStack.method_7914() <= currentStack.method_7947()) continue;
            int canAdd = Math.min(currentStack.method_7914() - currentStack.method_7947(), amount);
            class_1799 fillRemainingSpace = CommandUtil.copyWithSize(stack, canAdd + currentStack.method_7947());
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            class_1799 toDrop = CommandUtil.copyWithSize(stack, amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(class_1799 stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        class_310 minecraft = class_310.method_1551();
        class_636 playerController = minecraft.field_1761;
        if (playerController != null) {
            playerController.method_2909(stack, mainInventorySlot);
        } else {
            LOGGER.error("Cannot send slot packet, minecraft.playerController is null");
        }
    }

    private static class_1799 copyWithSize(class_1799 itemStack, int size) {
        if (size == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }
}

