/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.ItemStackMatchable;
import mezz.jei.common.util.MatchingIterable;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    @Nullable
    public static IRecipeTransferError getTransferRecipeError(RecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutInternal<?> recipeLayout, class_1657 player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(RecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutInternal<?> recipeLayout, class_1657 player, boolean maxTransfer) {
        IRecipeTransferError error = RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true);
        return RecipeTransferUtil.allowsTransfer(error);
    }

    @Nullable
    private static <C extends class_1703, R> IRecipeTransferError transferRecipe(RecipeTransferManager recipeTransferManager, C container, IRecipeLayoutInternal<R> recipeLayout, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (Internal.getRuntime().isEmpty()) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        IRecipeTransferHandler<C, R> transferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (transferHandler == null) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeSlots recipeSlots = recipeLayout.getRecipeSlots();
        IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
        try {
            try {
                return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
            }
            catch (UnsupportedOperationException ignored) {
                return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeLayout.getLegacyAdapter(), player, maxTransfer, doTransfer);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Recipe transfer handler '{}' for container '{}' and recipe '{}' threw an error: ", transferHandler.getClass(), transferHandler.getContainerClass(), transferHandler.getRecipeClass(), (Object)e);
            return RecipeTransferErrorInternal.INSTANCE;
        }
    }

    public static boolean allowsTransfer(@Nullable IRecipeTransferError error) {
        return error == null || error.getType() == IRecipeTransferError.Type.COSMETIC;
    }

    public static boolean validateSlots(class_1657 player, Collection<TransferOperation> transferOperations, Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(TransferOperation::craftingSlot).map(s -> s.field_7874).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots for the destination of the recipe, the slots are not included in the list of crafting slots. " + StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(TransferOperation::inventorySlot).map(s -> s.field_7874).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. " + StringUtil.intsToString(invalidInventorySlotIndexes) + "\n inventory slots: " + StringUtil.intsToString(inventorySlotIndexes) + "\n crafting slots: " + StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: " + StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidPickupSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(class_1735::method_7681).filter(slot -> !slot.method_7674(player)).map(slot -> slot.field_7874).toList();
        if (!invalidPickupSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, the player is unable to pickup from them: " + StringUtil.intsToString(invalidPickupSlots));
            return false;
        }
        return true;
    }

    public static RecipeTransferOperationsResult getRecipeTransferOperations(IStackHelper stackhelper, Map<class_1735, class_1799> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<class_1735> craftingSlots) {
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        for (int i = 0; i < requiredItemStacks.size(); ++i) {
            IRecipeSlotView requiredItemStack = requiredItemStacks.get(i);
            if (requiredItemStack.isEmpty()) continue;
            class_1735 craftingSlot = craftingSlots.get(i);
            Map.Entry<class_1735, class_1799> matching = RecipeTransferUtil.containsAnyStackIndexed(stackhelper, availableItemStacks, requiredItemStack);
            if (matching == null) {
                transferOperations.missingItems.add(requiredItemStack);
                continue;
            }
            class_1735 matchingSlot = matching.getKey();
            class_1799 matchingStack = matching.getValue();
            matchingStack.method_7934(1);
            if (matchingStack.method_7960()) {
                availableItemStacks.remove(matchingSlot);
            }
            transferOperations.results.add(new TransferOperation(matchingSlot, craftingSlot));
        }
        return transferOperations;
    }

    @Nullable
    public static <T> Map.Entry<T, class_1799> containsAnyStackIndexed(IStackHelper stackhelper, Map<T, class_1799> stacks, IRecipeSlotView recipeSlotView) {
        MatchingIndexed<T> matchingStacks = new MatchingIndexed<T>(stacks);
        List<class_1799> ingredients = recipeSlotView.getItemStacks().toList();
        MatchingIterable matchingContains = new MatchingIterable(ingredients);
        return (Map.Entry)RecipeTransferUtil.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = RecipeTransferUtil.containsStack(stackhelper, stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe)) continue;
            return stack.getResult();
        }
        return null;
    }

    private static class MatchingIndexed<T>
    implements Iterable<ItemStackMatchable<Map.Entry<T, class_1799>>> {
        private final Map<T, class_1799> map;

        public MatchingIndexed(Map<T, class_1799> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Map.Entry<T, class_1799>>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<T, class_1799>, ItemStackMatchable<Map.Entry<T, class_1799>>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Map.Entry<T, class_1799>> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Map.Entry<T, class_1799>>(){

                        @Override
                        public class_1799 getStack() {
                            return (class_1799)entry.getValue();
                        }

                        @Override
                        public Map.Entry<T, class_1799> getResult() {
                            return entry;
                        }
                    };
                }
            };
        }
    }
}

