/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.collect.ImmutableTable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1703;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferManager {
    private final ImmutableTable<Class<?>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers;

    public RecipeTransferManager(ImmutableTable<Class<?>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers) {
        this.recipeTransferHandlers = recipeTransferHandlers;
    }

    @Nullable
    public <C extends class_1703, R> IRecipeTransferHandler<C, R> getRecipeTransferHandler(C container, IRecipeCategory<R> recipeCategory) {
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        Class<?> containerClass = container.getClass();
        RecipeType<R> recipeType = recipeCategory.getRecipeType();
        Class<R> recipeClass = recipeType.getRecipeClass();
        IRecipeTransferHandler<C, R> handler = this.getHandler(recipeClass, containerClass, recipeType);
        if (handler != null) {
            return handler;
        }
        return this.getHandler(recipeClass, containerClass, Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE);
    }

    @Nullable
    private <C extends class_1703, R> IRecipeTransferHandler<C, R> getHandler(Class<? extends R> recipeClass, Class<? extends class_1703> containerClass, RecipeType<?> recipeType) {
        IRecipeTransferHandler handler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, recipeType);
        if (handler != null && handler.getRecipeClass().isAssignableFrom(recipeClass) && handler.getContainerClass().isAssignableFrom(containerClass)) {
            return handler;
        }
        return null;
    }
}

