/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.Optional;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.LimitedAreaInputHandler;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.CheatUtil;
import mezz.jei.common.util.CommandUtil;
import mezz.jei.common.util.GiveAmount;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_1799;
import net.minecraft.class_437;

public class CheatInputHandler
implements IUserInputHandler {
    private final IRecipeFocusSource showsRecipeFocuses;
    private final IWorldConfig worldConfig;
    private final CommandUtil commandUtil;

    public CheatInputHandler(IRecipeFocusSource showsRecipeFocuses, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection) {
        this.showsRecipeFocuses = showsRecipeFocuses;
        this.worldConfig = worldConfig;
        this.commandUtil = new CommandUtil(clientConfig, serverConnection);
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IKeyBindings keyBindings) {
        if (!this.worldConfig.isCheatItemsEnabled() || screen instanceof IRecipesGui) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getCheatItemStack())) {
            return this.handleGive(input, GiveAmount.MAX);
        }
        if (input.is(keyBindings.getCheatOneItem())) {
            return this.handleGive(input, GiveAmount.ONE);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handleGive(UserInput input, GiveAmount giveAmount) {
        return this.showsRecipeFocuses.getIngredientUnderMouse(input.getMouseX(), input.getMouseY()).findFirst().map(clicked -> {
            class_1799 itemStack;
            if (!input.isSimulate() && !(itemStack = CheatUtil.getCheatItemStack(clicked)).method_7960()) {
                this.commandUtil.giveStack(itemStack, giveAmount);
            }
            return LimitedAreaInputHandler.create(this, clicked.getArea());
        });
    }
}

