/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;

public class IngredientInfoRecipe
implements IJeiIngredientInfoRecipe {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    public static final int lineSpacing = 2;
    private final List<class_5348> description;
    private final List<ITypedIngredient<?>> ingredients;

    public static <T> List<IJeiIngredientInfoRecipe> create(RegisteredIngredients registeredIngredients, List<T> ingredients, IIngredientType<T> ingredientType, class_2561 ... descriptionComponents) {
        List<ITypedIngredient<?>> typedIngredients = ingredients.stream().map(i -> TypedIngredient.create(registeredIngredients, ingredientType, i)).flatMap(Optional::stream).toList();
        ArrayList<IJeiIngredientInfoRecipe> recipes = new ArrayList<IJeiIngredientInfoRecipe>();
        List<class_5348> descriptionLines = StringUtil.expandNewlines(descriptionComponents);
        descriptionLines = StringUtil.splitLines(descriptionLines, 160);
        int lineCount = descriptionLines.size();
        class_310 minecraft = class_310.method_1551();
        Objects.requireNonNull(minecraft.field_1772);
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i2 = 0; i2 < pageCount; ++i2) {
            int startLine = i2 * maxLinesPerPage;
            int endLine = Math.min((i2 + 1) * maxLinesPerPage, lineCount);
            List<class_5348> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe recipe = new IngredientInfoRecipe(typedIngredients, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private IngredientInfoRecipe(List<ITypedIngredient<?>> ingredients, List<class_5348> description) {
        this.description = description;
        this.ingredients = ingredients;
    }

    @Override
    public List<class_5348> getDescription() {
        return this.description;
    }

    @Override
    public List<ITypedIngredient<?>> getIngredients() {
        return this.ingredients;
    }
}

