/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.color.ColorNamer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.ingredients.IngredientInfo;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.render.IngredientRenderHelper;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public final class IngredientGridTooltipHelper {
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final IModIdHelper modIdHelper;
    private final IKeyBindings keyBindings;

    public IngredientGridTooltipHelper(RegisteredIngredients registeredIngredients, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, IModIdHelper modIdHelper, IKeyBindings keyBindings) {
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.modIdHelper = modIdHelper;
        this.keyBindings = keyBindings;
    }

    public <T> void drawTooltip(class_4587 poseStack, int mouseX, int mouseY, ITypedIngredient<T> value) {
        IIngredientType<T> ingredientType = value.getType();
        T ingredient = value.getIngredient();
        IngredientInfo<T> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        List<class_2561> tooltip = this.getTooltip(ingredient, ingredientInfo);
        TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, ingredient, ingredientRenderer);
    }

    public <T> List<class_2561> getTooltip(T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
        List<class_2561> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, ingredientRenderer, ingredientHelper, this.modIdHelper);
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>(ingredientTooltipSafe);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            IngredientGridTooltipHelper.addColorSearchInfoToTooltip(tooltip, ingredient, ingredientInfo);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
        return tooltip;
    }

    private static <T> void addColorSearchInfoToTooltip(List<class_2561> tooltip, T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientHelper<T> ingredientHelper;
        Iterable<Integer> colors;
        ColorNamer colorNamer = ColorNamer.getInstance();
        String colorNamesString = colorNamer.getColorNames(colors = (ingredientHelper = ingredientInfo.getIngredientHelper()).getColors(ingredient)).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            class_5250 colorTranslation = new class_2588("jei.tooltip.item.colors", new Object[]{colorNamesString}).method_27692(class_124.field_1080);
            tooltip.add((class_2561)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(List<class_2561> tooltip, IKeyBindings keyBindings) {
        List<class_5250> lines = List.of(class_2585.field_24366, new class_2588("gui.jei.editMode.description").method_27692(class_124.field_1077), new class_2588("gui.jei.editMode.description.hide", new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080), new class_2588("gui.jei.editMode.description.hide.wild", new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080));
        tooltip.addAll(lines);
    }
}

