/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.ingredients.RecipeSlot;
import mezz.jei.common.gui.recipes.RecipesGui;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.ClickedIngredient;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import org.jetbrains.annotations.Nullable;

public class RecipeCatalysts
implements IRecipeFocusSource {
    private static final int ingredientSize = 16;
    private static final int ingredientBorderSize = 1;
    private static final int borderSize = 5;
    private static final int overlapSize = 6;
    private final DrawableNineSliceTexture backgroundTab;
    private final List<RecipeSlot> recipeSlots;
    private final DrawableNineSliceTexture slotBackground;
    private final IIngredientVisibility ingredientVisibility;
    private int left = 0;
    private int top = 0;
    private int width = 0;
    private int height = 0;

    public RecipeCatalysts(Textures textures, IIngredientVisibility ingredientVisibility) {
        this.ingredientVisibility = ingredientVisibility;
        this.recipeSlots = new ArrayList<RecipeSlot>();
        this.backgroundTab = textures.getCatalystTab();
        this.slotBackground = textures.getRecipeCatalystSlotBackground();
    }

    public boolean isEmpty() {
        return this.recipeSlots.isEmpty();
    }

    public int getWidth() {
        return this.width - 6;
    }

    public void updateLayout(List<ITypedIngredient<?>> ingredients, RecipesGui recipesGui) {
        this.recipeSlots.clear();
        if (!ingredients.isEmpty()) {
            ImmutableRect2i recipeArea = recipesGui.getArea();
            int availableHeight = recipeArea.getHeight() - 8;
            int borderHeight = 12;
            int maxIngredientsPerColumn = (availableHeight - borderHeight) / 16;
            int columnCount = MathUtil.divideCeil(ingredients.size(), maxIngredientsPerColumn);
            maxIngredientsPerColumn = MathUtil.divideCeil(ingredients.size(), columnCount);
            this.width = 12 + columnCount * 16;
            this.height = 12 + maxIngredientsPerColumn * 16;
            this.top = recipeArea.getY();
            this.left = recipeArea.getX() - this.width + 6;
            for (int i = 0; i < ingredients.size(); ++i) {
                ITypedIngredient<?> ingredientForSlot = ingredients.get(i);
                RecipeSlot recipeSlot = this.createSlot(ingredientForSlot, i, maxIngredientsPerColumn);
                this.recipeSlots.add(recipeSlot);
            }
        }
    }

    private <T> RecipeSlot createSlot(ITypedIngredient<T> typedIngredient, int index, int maxIngredientsPerColumn) {
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        int column = index / maxIngredientsPerColumn;
        int row = index % maxIngredientsPerColumn;
        int xPos = this.left + 5 + column * 16 + 1;
        int yPos = this.top + 5 + row * 16 + 1;
        RecipeSlot recipeSlot = new RecipeSlot(registeredIngredients, RecipeIngredientRole.CATALYST, xPos, yPos, 0, 0);
        recipeSlot.set(List.of(Optional.of(typedIngredient)), IntSet.of((int)0), this.ingredientVisibility);
        return recipeSlot;
    }

    @Nullable
    public RecipeSlot draw(PoseStack poseStack, int mouseX, int mouseY) {
        int ingredientCount = this.recipeSlots.size();
        if (ingredientCount > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            int slotWidth = this.width - 10;
            int slotHeight = this.height - 10;
            this.backgroundTab.draw(poseStack, this.left, this.top, this.width, this.height);
            this.slotBackground.draw(poseStack, this.left + 5, this.top + 5, slotWidth, slotHeight);
            RenderSystem.enableDepthTest();
            RecipeSlot hovered = null;
            for (RecipeSlot recipeSlot : this.recipeSlots) {
                if (recipeSlot.isMouseOver(mouseX, mouseY)) {
                    hovered = recipeSlot;
                }
                recipeSlot.draw(poseStack);
            }
            return hovered;
        }
        return null;
    }

    private Stream<RecipeSlot> getHovered(double mouseX, double mouseY) {
        return this.recipeSlots.stream().filter(recipeSlot -> recipeSlot.isMouseOver(mouseX, mouseY));
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.getHovered(mouseX, mouseY).map(recipeSlot -> recipeSlot.getDisplayedIngredient().map(i -> new ClickedIngredient(i, recipeSlot.getRect(), false, true))).flatMap(Optional::stream);
    }
}

