/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.deprecated.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.deprecated.ingredients.IngredientsForType;
import mezz.jei.common.ingredients.IIngredientSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class Ingredients
implements IIngredients,
IIngredientSupplier {
    private final List<IngredientsForType<?>> inputs = new ArrayList();
    private final List<IngredientsForType<?>> outputs = new ArrayList();

    public <T> void setInput(IIngredientType<T> ingredientType, T input) {
        this.setInputs(ingredientType, Collections.singletonList(input));
    }

    public <T> void setInputLists(IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs) {
        ArrayList<@Nullable List<@Nullable T>> expandedInputs = new ArrayList<List<T>>(inputs);
        Ingredients.setIngredients(ingredientType, this.inputs, expandedInputs);
    }

    public void setInputIngredients(List<Ingredient> inputs) {
        ArrayList inputLists = new ArrayList();
        for (Ingredient input : inputs) {
            ItemStack[] stacks = input.getItems();
            List<ItemStack> expandedInput = List.of(stacks);
            inputLists.add(expandedInput);
        }
        Ingredients.setIngredients(VanillaTypes.ITEM_STACK, this.inputs, inputLists);
    }

    public <T> void setInputs(IIngredientType<T> ingredientType, List<@Nullable T> inputs) {
        ArrayList<@Nullable List<@Nullable T>> expandedInputs = new ArrayList<List<T>>();
        for (T input : inputs) {
            List<@Nullable T> expandedInput = Collections.singletonList(input);
            expandedInputs.add(expandedInput);
        }
        Ingredients.setIngredients(ingredientType, this.inputs, expandedInputs);
    }

    public <T> void setOutput(IIngredientType<T> ingredientType, T output) {
        this.setOutputs(ingredientType, Collections.singletonList(output));
    }

    public <T> void setOutputs(IIngredientType<T> ingredientType, List<@Nullable T> outputs) {
        ArrayList<@Nullable List<@Nullable T>> expandedOutputs = new ArrayList<List<T>>();
        for (T output : outputs) {
            List<@Nullable T> expandedOutput = Collections.singletonList(output);
            expandedOutputs.add(expandedOutput);
        }
        Ingredients.setIngredients(ingredientType, this.outputs, expandedOutputs);
    }

    public <T> void setOutputLists(IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> outputs) {
        ArrayList<@Nullable List<@Nullable T>> expandedOutputs = new ArrayList<List<T>>(outputs);
        Ingredients.setIngredients(ingredientType, this.outputs, expandedOutputs);
    }

    public <T> List<@Nullable List<@Nullable T>> getInputs(IIngredientType<T> ingredientType) {
        return Ingredients.getIngredients(ingredientType, this.inputs);
    }

    public <T> List<@Nullable List<@Nullable T>> getOutputs(IIngredientType<T> ingredientType) {
        return Ingredients.getIngredients(ingredientType, this.outputs);
    }

    private static <T> void setIngredients(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes, List<@Nullable List<@Nullable T>> ingredients) {
        IngredientsForType<T> recipeIngredients = Ingredients.getIngredientsForType(ingredientType, ingredientsForTypes);
        if (recipeIngredients == null) {
            ingredientsForTypes.add(new IngredientsForType<T>(ingredientType, ingredients));
        } else {
            recipeIngredients.setIngredients(ingredients);
        }
    }

    private static <T> List<@Nullable List<@Nullable T>> getIngredients(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes) {
        IngredientsForType<T> recipeIngredients = Ingredients.getIngredientsForType(ingredientType, ingredientsForTypes);
        if (recipeIngredients == null) {
            return Collections.emptyList();
        }
        return recipeIngredients.getIngredients();
    }

    @Nullable
    private static <T> IngredientsForType<T> getIngredientsForType(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes) {
        for (IngredientsForType<?> i : ingredientsForTypes) {
            if (i.getIngredientType() != ingredientType) continue;
            IngredientsForType<?> ingredientsForType = i;
            return ingredientsForType;
        }
        return null;
    }

    @Override
    public Stream<? extends IIngredientType<?>> getIngredientTypes(RecipeIngredientRole role) {
        List<IngredientsForType<?>> source;
        if (role == RecipeIngredientRole.INPUT) {
            source = this.inputs;
        } else if (role == RecipeIngredientRole.OUTPUT) {
            source = this.outputs;
        } else {
            return Stream.of(new IIngredientType[0]);
        }
        return source.stream().map(IngredientsForType::getIngredientType).distinct();
    }

    @Override
    public <T> Stream<T> getIngredientStream(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        List<IngredientsForType<?>> source;
        if (role == RecipeIngredientRole.INPUT) {
            source = this.inputs;
        } else if (role == RecipeIngredientRole.OUTPUT) {
            source = this.outputs;
        } else {
            return Stream.empty();
        }
        IngredientsForType<T> ingredientsForType = Ingredients.getIngredientsForType(ingredientType, source);
        if (ingredientsForType == null) {
            return Stream.empty();
        }
        List<@Nullable List<@Nullable T>> ingredients = ingredientsForType.getIngredients();
        return ingredients.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull);
    }
}

