/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import mezz.jei.common.config.ClientConfig;
import mezz.jei.common.config.IngredientFilterConfig;
import mezz.jei.common.config.IngredientGridConfig;
import mezz.jei.common.config.ModIdFormatConfig;
import mezz.jei.common.config.file.ConfigSchema;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.ConfigSerializer;
import mezz.jei.common.config.file.FileWatcher;
import mezz.jei.common.gui.overlay.options.HorizontalAlignment;
import mezz.jei.core.util.PathUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JEIClientConfigs {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientConfig clientConfig;
    private final IngredientFilterConfig filterConfig;
    private final ModIdFormatConfig modIdFormat;
    private final IngredientGridConfig ingredientListConfig;
    private final IngredientGridConfig bookmarkListConfig;
    private final ConfigSchema schema;

    public JEIClientConfigs(Path configFile) {
        ConfigSchemaBuilder builder = new ConfigSchemaBuilder();
        this.clientConfig = new ClientConfig(builder);
        this.filterConfig = new IngredientFilterConfig(builder);
        this.modIdFormat = new ModIdFormatConfig(builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", builder, HorizontalAlignment.LEFT);
        this.schema = builder.build(configFile);
    }

    public void register(Path configDir, Path configFile) {
        Path oldConfigFile = configDir.resolve("jei-client.toml");
        try {
            if (PathUtil.migrateConfigLocation((Path)configFile, (Path)oldConfigFile)) {
                LOGGER.info("Successfully migrated config file from '{}' to new location '{}'", (Object)oldConfigFile, (Object)configFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to migrate config file from '{}' to new location '{}'", (Object)oldConfigFile, (Object)configFile, (Object)e);
        }
        Path configPath = this.schema.getPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                ConfigSerializer.save(this.schema);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config file: '{}'", (Object)configFile, (Object)e);
            }
        }
        try {
            FileWatcher fileWatcher = new FileWatcher(Map.of(configPath, this.schema::onFileChanged));
            Thread thread = new Thread(fileWatcher::run, "JEI Config file watcher");
            thread.start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create FileWatcher Thread for config file: '{}'", (Object)configFile, (Object)e);
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IngredientFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public IngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    public IngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }

    public ModIdFormatConfig getModIdFormat() {
        return this.modIdFormat;
    }
}

