/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.nio.file.Path;
import mezz.jei.common.platform.IPlatformServerHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.util.FileUtil;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;

public final class ServerConfigPathUtil {
    private static final Path worldDirPath = Path.of("world", new String[0]);
    private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

    private ServerConfigPathUtil() {
    }

    @Nullable
    public static Path getWorldPath(Path basePath) {
        Path worldPath = ServerConfigPathUtil.getWorldPath();
        if (worldPath == null) {
            return null;
        }
        return basePath.resolve(worldPath);
    }

    @Nullable
    private static Path getWorldPath() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        if (clientPacketListener == null) {
            return null;
        }
        Connection connection = clientPacketListener.getConnection();
        if (connection.isMemoryConnection()) {
            IPlatformServerHelper serverHelper = Services.PLATFORM.getServerHelper();
            MinecraftServer minecraftServer = serverHelper.getServer();
            if (minecraftServer != null) {
                return reflectionUtil.getFieldWithClass((Object)minecraftServer, LevelStorageSource.LevelStorageAccess.class).findFirst().map(LevelStorageSource.LevelStorageAccess::getLevelId).map(FileUtil::sanitizePathName).map(name -> worldDirPath.resolve("local").resolve((String)name)).orElse(null);
            }
        } else {
            ServerData serverData = minecraft.getCurrentServer();
            if (serverData != null) {
                int ipHash = serverData.ip.hashCode();
                String ipHashHex = Integer.toHexString(ipHash);
                String name2 = String.format("%s_%s", serverData.name, ipHashHex);
                name2 = FileUtil.sanitizePathName((String)name2);
                return worldDirPath.resolve("server").resolve(name2);
            }
        }
        return null;
    }
}

