/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweakstconstruct.AntiChiselDupeHandler;
import iguanaman.iguanatweakstconstruct.OldToolConversionHandler;
import iguanaman.iguanatweakstconstruct.PulsarCFG;
import iguanaman.iguanatweakstconstruct.ToolUpdateRecipe;
import iguanaman.iguanatweakstconstruct.claybuckets.IguanaItems;
import iguanaman.iguanatweakstconstruct.commands.CommandDumpOredict;
import iguanaman.iguanatweakstconstruct.commands.CommandDumpTools;
import iguanaman.iguanatweakstconstruct.commands.CommandIAmADirtyCheater;
import iguanaman.iguanatweakstconstruct.debug.DebugCommand;
import iguanaman.iguanatweakstconstruct.debug.IguanaDebug;
import iguanaman.iguanatweakstconstruct.harvestlevels.IguanaHarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.leveling.IguanaToolLeveling;
import iguanaman.iguanatweakstconstruct.leveling.commands.IguanaCommandLevelUpTool;
import iguanaman.iguanatweakstconstruct.leveling.commands.IguanaCommandToolXP;
import iguanaman.iguanatweakstconstruct.mobheads.IguanaMobHeads;
import iguanaman.iguanatweakstconstruct.modcompat.fmp.IguanaFMPCompat;
import iguanaman.iguanatweakstconstruct.override.IguanaOverride;
import iguanaman.iguanatweakstconstruct.proxy.CommonProxy;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.reference.Reference;
import iguanaman.iguanatweakstconstruct.replacing.IguanaToolPartReplacing;
import iguanaman.iguanatweakstconstruct.restriction.IguanaPartRestriction;
import iguanaman.iguanatweakstconstruct.tweaks.IguanaTweaks;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import iguanaman.iguanatweakstconstruct.worldgen.IguanaWorldGen;
import java.io.File;
import java.util.Random;
import mantle.pulsar.config.IConfiguration;
import mantle.pulsar.control.PulseManager;
import mantle.pulsar.pulse.PulseMeta;
import net.minecraft.command.ICommand;
import net.minecraft.item.crafting.IRecipe;

@Mod(modid="IguanaTweaksTConstruct", name="Iguana Tinker Tweaks", version="1.7.10-2.1.5.162", dependencies="required-after:TConstruct@[1.7.10-1.8.3,);after:ForgeMultipart@[1.1.1.321,);after:*")
public class IguanaTweaksTConstruct {
    @Mod.Instance(value="IguanaTweaksTConstruct")
    public static IguanaTweaksTConstruct instance;
    @SidedProxy(clientSide="iguanaman.iguanatweakstconstruct.proxy.ClientProxy", serverSide="iguanaman.iguanatweakstconstruct.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static Random random;
    private IConfiguration pulseCFG;
    public static PulseManager pulsar;
    public static File configPath;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Log.init(event.getModLog());
        configPath = new File(event.getModConfigurationDirectory(), "IguanaTinkerTweaks");
        File oldPath = new File(event.getModConfigurationDirectory(), "IguanaTweaksTConstruct");
        if (oldPath.exists()) {
            oldPath.renameTo(configPath);
        }
        configPath.mkdirs();
        this.pulseCFG = new PulsarCFG(Reference.configFile("Modules.cfg"), "Tinker's Construct Addon: Iguana Tweaks for Tinkers Construct");
        this.pulseCFG.load();
        pulsar = new PulseManager("IguanaTweaksTConstruct", this.pulseCFG);
        Config config = new Config();
        config.init(Reference.configFile("main.cfg"));
        FMLCommonHandler.instance().bus().register((Object)config);
        pulsar.registerPulse((Object)new IguanaHarvestLevelTweaks());
        pulsar.registerPulse((Object)new IguanaToolLeveling());
        pulsar.registerPulse((Object)new IguanaMobHeads());
        pulsar.registerPulse((Object)new IguanaItems());
        pulsar.registerPulse((Object)new IguanaTweaks());
        pulsar.registerPulse((Object)new IguanaOverride());
        pulsar.registerPulse((Object)new IguanaPartRestriction());
        pulsar.registerPulse((Object)new IguanaToolPartReplacing());
        pulsar.registerPulse((Object)new IguanaWorldGen());
        pulsar.registerPulse((Object)new IguanaDebug());
        pulsar.registerPulse((Object)new IguanaFMPCompat());
        if (!pulsar.isPulseLoaded("HarvestLevelTweaks")) {
            HarvestLevels.adjustToVanillaLevels();
        }
        HarvestLevels.updateHarvestLevelNames();
        pulsar.preInit(event);
        FMLInterModComms.sendRuntimeMessage((Object)"IguanaTweaksTConstruct", (String)"VersionChecker", (String)"addVersionCheck", (String)"https://raw.githubusercontent.com/SlimeKnights/IguanaTweaksTConstruct/master/version.json");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        pulsar.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        pulsar.postInit(event);
        FMLCommonHandler.instance().bus().register((Object)new OldToolConversionHandler());
        FMLCommonHandler.instance().bus().register((Object)new AntiChiselDupeHandler());
        GameRegistry.addRecipe((IRecipe)new ToolUpdateRecipe());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (pulsar.isPulseLoaded("ToolLeveling")) {
            Log.debug("Adding command: leveluptool");
            event.registerServerCommand((ICommand)new IguanaCommandLevelUpTool());
            Log.debug("Adding command: toolxp");
            event.registerServerCommand((ICommand)new IguanaCommandToolXP());
            event.registerServerCommand((ICommand)new CommandIAmADirtyCheater());
        }
        Log.debug("Adding command: dumpTools");
        event.registerServerCommand((ICommand)new CommandDumpTools());
        Log.debug("Adding command: dumpOredict");
        event.registerServerCommand((ICommand)new CommandDumpOredict());
        if (this.pulseCFG.isModuleEnabled(new PulseMeta("Debug", "", false, false))) {
            event.registerServerCommand((ICommand)new DebugCommand());
        }
    }

    public static String getHarvestLevelName(int num) {
        return HarvestLevels.getHarvestLevelName(num);
    }

    static {
        random = new Random();
    }
}

