/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public final class LevelingTooltips {
    private LevelingTooltips() {
    }

    public static String getXpString(ItemStack tool, NBTTagCompound tags, boolean detailed) {
        return LevelingTooltips.getXpString(tool, tags, detailed, false);
    }

    public static String getBoostXpString(ItemStack tool, NBTTagCompound tags, boolean detailed) {
        return LevelingTooltips.getXpString(tool, tags, detailed, true);
    }

    public static String getXpToolTip(ItemStack tool, NBTTagCompound tags) {
        return LevelingTooltips.getXpToolTip(tool, tags, false);
    }

    public static String getBoostXpToolTip(ItemStack tool, NBTTagCompound tags) {
        return LevelingTooltips.getXpToolTip(tool, tags, true);
    }

    private static String getXpToolTip(ItemStack tool, NBTTagCompound tags, boolean boostXp) {
        String prefix = StatCollector.translateToLocal((String)(boostXp ? "tooltip.level.miningxp" : "tooltip.level.skillxp"));
        return prefix + ": " + LevelingTooltips.getXpString(tool, tags, Config.detailedXpTooltip, boostXp);
    }

    private static String getXpString(ItemStack tool, NBTTagCompound tags, boolean detailed, boolean boostXp) {
        if (tags == null) {
            tags = tool.getTagCompound().getCompoundTag("InfiTool");
        }
        int requiredXp = LevelingLogic.getRequiredXp(tool, tags, boostXp);
        long currentXp = boostXp ? LevelingLogic.getBoostXp(tags) : LevelingLogic.getXp(tags);
        float xpPercentage = (float)currentXp / (float)requiredXp * 100.0f;
        String xpPercentageString = String.format("%.2f", Float.valueOf(xpPercentage)) + "%";
        if (detailed) {
            return Long.toString(currentXp) + " / " + Integer.toString(requiredXp) + " (" + xpPercentageString + ")";
        }
        return xpPercentageString;
    }

    public static String getLevelTooltip(int level) {
        if (!StatCollector.canTranslate((String)("tooltip.level.skill." + level))) {
            String str = "???";
        } else {
            String str = StatCollector.translateToLocal((String)("tooltip.level.skill." + level));
        }
        return String.format("%s: %s", StatCollector.translateToLocal((String)"tooltip.level.skilllevel"), LevelingTooltips.getLevelString(level));
    }

    public static String getLevelString(int level) {
        return LevelingTooltips.getLevelColor(level) + LevelingTooltips.getRawLevelString(level) + EnumChatFormatting.RESET;
    }

    private static String getRawLevelString(int level) {
        if (level <= 0) {
            return "";
        }
        if (StatCollector.canTranslate((String)("tooltip.level.skill." + level))) {
            return StatCollector.translateToLocal((String)("tooltip.level.skill." + level));
        }
        int i = 1;
        while (StatCollector.canTranslate((String)("tooltip.level.skill." + i))) {
            ++i;
        }
        String str = StatCollector.translateToLocal((String)("tooltip.level.skill." + level % i));
        for (int j = level / i; j > 0; --j) {
            str = str + '+';
        }
        return str;
    }

    public static String getLevelColor(int level) {
        switch (level % 12) {
            case 0: {
                return EnumChatFormatting.GRAY.toString();
            }
            case 1: {
                return EnumChatFormatting.DARK_RED.toString();
            }
            case 2: {
                return EnumChatFormatting.GOLD.toString();
            }
            case 3: {
                return EnumChatFormatting.YELLOW.toString();
            }
            case 4: {
                return EnumChatFormatting.DARK_GREEN.toString();
            }
            case 5: {
                return EnumChatFormatting.DARK_AQUA.toString();
            }
            case 6: {
                return EnumChatFormatting.LIGHT_PURPLE.toString();
            }
            case 7: {
                return EnumChatFormatting.WHITE.toString();
            }
            case 8: {
                return EnumChatFormatting.RED.toString();
            }
            case 9: {
                return EnumChatFormatting.DARK_PURPLE.toString();
            }
            case 10: {
                return EnumChatFormatting.AQUA.toString();
            }
            case 11: {
                return EnumChatFormatting.GREEN.toString();
            }
        }
        return "";
    }

    public static String getMiningLevelTooltip(int hLevel) {
        return String.format("%s: %s", StatCollector.translateToLocal((String)"tooltip.level.mininglevel"), HarvestLevels.getHarvestLevelName(hLevel));
    }

    public static String getBoostedTooltip() {
        return String.format("%s: \u00a76%s", StatCollector.translateToLocal((String)"tooltip.level.miningxp"), StatCollector.translateToLocal((String)"tooltip.level.boosted"));
    }

    public static String getInfoString(String base, EnumChatFormatting baseColor, String info, EnumChatFormatting infoColor) {
        return LevelingTooltips.getInfoString(base, baseColor, info, infoColor.toString());
    }

    public static String getInfoString(String base, EnumChatFormatting baseColor, String info, String infoColor) {
        return String.format("%s%s %s(%s%s%s)", baseColor, base, baseColor, infoColor, info, baseColor);
    }
}

