/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.worldgen;

import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.tools.TinkerTools;

public class RandomWeaponChestContent
extends WeightedRandomChestContent {
    private int minModifiers;
    private int maxModifiers;
    private int maxQuality;
    private int maxParts;
    private List<Integer> materialIDs;
    private List<ToolRecipe> weapons;

    public RandomWeaponChestContent(int minCount, int maxCount, int weight, int minModifiers, int maxModifiers, int maxQuality, int maxParts) {
        super((Item)TinkerTools.broadsword, 0, minCount, maxCount, weight);
        this.minModifiers = minModifiers;
        this.maxModifiers = maxModifiers;
        this.maxQuality = maxQuality;
        this.maxParts = maxParts;
        this.weapons = new ArrayList<ToolRecipe>();
        for (ToolRecipe recipe : ToolBuilder.instance.combos) {
            ToolCore type = recipe.getType();
            if (!Arrays.asList(type.getTraits()).contains("weapon")) continue;
            this.weapons.add(recipe);
        }
    }

    protected ItemStack[] generateChestContent(Random random, IInventory newInventory) {
        int count = this.theMinimumChanceToGenerateItem + random.nextInt(this.theMaximumChanceToGenerateItem - this.theMinimumChanceToGenerateItem + 1);
        ItemStack[] ret = new ItemStack[count];
        int endlessLoopPreventer = 9999;
        while (count > 0) {
            ItemStack[] parts;
            if (endlessLoopPreventer-- <= 0) {
                return new ItemStack[]{new ItemStack(Items.stick)};
            }
            ToolRecipe recipe = this.weapons.get(random.nextInt(this.weapons.size()));
            ToolCore type = recipe.getType();
            if (type.getPartAmount() > this.maxParts) continue;
            if (this.materialIDs == null) {
                this.prepareMaterials();
            }
            ItemStack weapon = null;
            int tries = 0;
            do {
                ++tries;
                parts = new ItemStack[]{null, null, null, null};
                Item[] items = new Item[]{type.getHeadItem(), type.getHandleItem(), type.getAccessoryItem(), type.getExtraItem()};
                for (int i = 0; i < 4; ++i) {
                    if (items[i] == null) continue;
                    do {
                        Integer matId = this.materialIDs.get(random.nextInt(this.materialIDs.size()));
                        parts[i] = new ItemStack(items[i], 1, matId.intValue());
                    } while (((IToolPart)items[i]).getMaterialID(parts[i]) == -1);
                }
            } while ((weapon = ToolBuilder.instance.buildTool(parts[0], parts[1], parts[2], parts[3], "")) == null && tries < 200);
            if (weapon == null) continue;
            int modCount = this.minModifiers + random.nextInt(this.maxModifiers - this.minModifiers + 1);
            while (modCount-- > 0) {
                RandomBonuses.tryModifying(null, weapon);
            }
            ret[--count] = weapon;
        }
        return ret;
    }

    private void prepareMaterials() {
        this.materialIDs = new ArrayList<Integer>();
        for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
            if (((ToolMaterial)entry.getValue()).harvestLevel() > this.maxQuality) continue;
            this.materialIDs.add((Integer)entry.getKey());
        }
    }
}

