/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.reference.Config;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import tconstruct.items.tools.Chisel;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.weaponry.entity.ShurikenEntity;
import tconstruct.weaponry.weapons.Shuriken;

public class LevelingEventHandler {
    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (!event.source.damageType.equals("player") && !event.source.damageType.equals("arrow")) {
            return;
        }
        if (!(event.source.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.getEntity();
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack stack = player.getCurrentEquippedItem();
        if (event.source.getSourceOfDamage() instanceof ShurikenEntity) {
            if (stack == null || !(stack.getItem() instanceof Shuriken)) {
                stack = player.inventory.currentItem == 0 ? player.inventory.getStackInSlot(8) : player.inventory.getStackInSlot(player.inventory.currentItem + 1);
            }
            if (stack != null && !(stack.getItem() instanceof Shuriken)) {
                stack = null;
            }
        }
        if (stack == null || !stack.hasTagCompound()) {
            return;
        }
        if (stack.getItem() == null || !(stack.getItem() instanceof ToolCore)) {
            return;
        }
        int xp = 0;
        xp = Arrays.asList(((ToolCore)stack.getItem()).getTraits()).contains("weapon") ? Math.round(event.ammount) : Math.round((event.ammount - 0.1f) / 2.0f);
        if (event.entityLiving instanceof EntityAnimal) {
            xp = Math.max(1, xp / 2);
        }
        boolean cheatyXP = false;
        if (!event.entityLiving.isEntityAlive()) {
            xp = Math.max(1, Math.round((float)xp / 4.0f));
            cheatyXP = true;
        }
        ItemStack ammo = null;
        if (stack.getItem() instanceof ProjectileWeapon && event.source.damageType.equals("arrow") && (ammo = ((ProjectileWeapon)stack.getItem()).searchForAmmo(player, stack)) != null && !(ammo.getItem() instanceof ToolCore)) {
            ammo = null;
        }
        if (!event.source.damageType.equals("arrow")) {
            if (stack.getItem() instanceof ProjectileWeapon) {
                return;
            }
            if (Arrays.asList(((ToolCore)stack.getItem()).getTraits()).contains("ammo")) {
                return;
            }
        }
        if (xp > 0) {
            for (ItemStack itemstack : new ItemStack[]{stack, ammo}) {
                if (itemstack == null) continue;
                LevelingLogic.addXP(itemstack, player, xp);
                NBTTagCompound tags = itemstack.getTagCompound().getCompoundTag("InfiTool");
                if (cheatyXP) {
                    int cxp = tags.getInteger("CheatyXP");
                    tags.setInteger("CheatyXP", cxp + xp);
                }
                if (event.entityLiving instanceof EntityAnimal) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LAPIS, xp + 5, tags);
                } else {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.ATTACK, xp, tags);
                }
                if (event.entityLiving instanceof EntitySpider) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BANE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityBlaze) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BLAZE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityPigZombie) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityZombie) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.SMITE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntitySkeleton) {
                    if (((EntitySkeleton)event.entityLiving).getSkeletonType() != 0) {
                        RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2) + 2, tags);
                    }
                } else if (event.entityLiving instanceof EntityEnderman) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BEHEADING, Math.max(1, xp / 2) + 3, tags);
                }
                if (!player.isSprinting()) continue;
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.KNOCKBACK, xp + 2, tags);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        ItemStack stack;
        EntityPlayer player = event.entityPlayer;
        if (player instanceof FakePlayer) {
            return;
        }
        Block block = event.world.getBlock(event.x, event.y, event.z);
        Block blockAbove = event.world.getBlock(event.x, event.y + 1, event.z);
        if (blockAbove.isAir((IBlockAccess)event.world, event.x, event.y + 1, event.z) && (block == Blocks.grass || block == Blocks.dirt) && (stack = event.current) != null && stack.hasTagCompound() && stack.getItem() instanceof ToolCore) {
            LevelingLogic.addXP(stack, player, 1L);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting == null) {
            return;
        }
        ItemStack chisel = null;
        for (int i = 0; i < event.craftMatrix.getSizeInventory(); ++i) {
            if (event.craftMatrix.getStackInSlot(i) == null || !(event.craftMatrix.getStackInSlot(i).getItem() instanceof Chisel)) continue;
            chisel = event.craftMatrix.getStackInSlot(i);
        }
        if (chisel == null) {
            return;
        }
        LevelingLogic.addXP(chisel, event.player, 1L);
    }

    @SubscribeEvent
    public void onCraftTool(ToolCraftEvent.NormalTool event) {
        NBTTagCompound toolTag = event.toolTag.getCompoundTag("InfiTool");
        LevelingLogic.addLevelingTags(toolTag, event.tool);
        toolTag.setInteger("Modifiers", Math.max(toolTag.getInteger("Modifiers") - (3 - Config.toolLevelingExtraModifiers), 0));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (Config.toolLeveling && Config.showDebugXP) {
            ItemStack equipped;
            Minecraft mc = Minecraft.getMinecraft();
            EntityClientPlayerMP player = mc.thePlayer;
            if (!player.isDead && mc.gameSettings.showDebugInfo && (equipped = player.getCurrentEquippedItem()) != null && equipped.getItem() != null && equipped.getItem() instanceof ToolCore) {
                int hLevel;
                NBTTagCompound tags = equipped.getTagCompound().getCompoundTag("InfiTool");
                int level = tags.getInteger("ToolLevel");
                hLevel = tags.hasKey("HarvestLevel") ? (hLevel = tags.getInteger("HarvestLevel")) : -1;
                event.left.add("");
                if (Config.showTooltipXP) {
                    if (level <= 5) {
                        event.left.add(LevelingTooltips.getXpToolTip(equipped, null));
                    }
                    if (Config.levelingPickaxeBoost && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.hasKey("HarvestLevelModified") && (equipped.getItem() instanceof Pickaxe || equipped.getItem() instanceof Hammer)) {
                        event.left.add(LevelingTooltips.getBoostXpToolTip(equipped, null));
                    }
                }
            }
        }
    }
}

