/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.replacing;

import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModXpAwareRedstone;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.Arrays;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.modifiers.tools.ModAttack;
import tconstruct.modifiers.tools.ModRedstone;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;

public final class ReplacementLogic {
    private ReplacementLogic() {
    }

    public static void exchangeToolPart(ToolCore tool, NBTTagCompound tags, PartTypes type, ItemStack partStack, ItemStack toolStack) {
        float xp;
        IAmmo ammo;
        ItemStack newTool;
        ItemStack originalTool;
        ItemStack headStack = null;
        ItemStack handleStack = null;
        ItemStack accessoryStack = null;
        ItemStack extraStack = null;
        if (ReplacementLogic.getPart(tool, PartTypes.HEAD) != null) {
            headStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.HEAD), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.HEAD));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.HANDLE) != null) {
            handleStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.HANDLE), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.HANDLE));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.ACCESSORY) != null) {
            accessoryStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.ACCESSORY), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.ACCESSORY));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.EXTRA) != null) {
            extraStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.EXTRA), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.EXTRA));
        }
        if (tool == TinkerWeaponry.boltAmmo) {
            headStack = DualMaterialToolPart.createDualMaterial((Item)TinkerWeaponry.partBolt, (int)ReplacementLogic.getToolPartMaterial(tags, PartTypes.HANDLE), (int)ReplacementLogic.getToolPartMaterial(tags, PartTypes.HEAD));
            handleStack = accessoryStack;
            accessoryStack = null;
            type = type == PartTypes.ACCESSORY ? PartTypes.HANDLE : PartTypes.HEAD;
        }
        if ((originalTool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, "Original Tool")) == null) {
            Log.error("Tool to modify is impossible?");
            return;
        }
        if (type == PartTypes.HEAD && headStack != null) {
            headStack = partStack;
        }
        if (type == PartTypes.HANDLE && handleStack != null) {
            handleStack = partStack;
        }
        if (type == PartTypes.ACCESSORY && accessoryStack != null) {
            accessoryStack = partStack;
        }
        if (type == PartTypes.EXTRA && extraStack != null) {
            extraStack = partStack;
        }
        if ((newTool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, "Modified Tool")) == null) {
            Log.debug("External source prevents creation of tool with replaced parts.");
            return;
        }
        NBTTagCompound newTags = newTool.getTagCompound().getCompoundTag("InfiTool");
        int partMaterialId = ReplacementLogic.getToolPartMaterial(newTags, type);
        int oldMaterialId = ReplacementLogic.getToolPartMaterial(tags, type);
        long oldRequiredXp = LevelingLogic.getRequiredXp(toolStack, tags);
        long oldRequiredBoostXp = LevelingLogic.getRequiredBoostXp(toolStack);
        ReplacementLogic.updateTag(newTags, tags, "Head");
        ReplacementLogic.updateTag(newTags, tags, "RenderHead");
        ReplacementLogic.updateTag(newTags, tags, "Handle");
        ReplacementLogic.updateTag(newTags, tags, "RenderHandle");
        ReplacementLogic.updateTag(newTags, tags, "Accessory");
        ReplacementLogic.updateTag(newTags, tags, "RenderAccessory");
        ReplacementLogic.updateTag(newTags, tags, "Extra");
        ReplacementLogic.updateTag(newTags, tags, "RenderExtra");
        int base = newTags.getInteger("BaseDurability");
        int bonus = tags.getInteger("BonusDurability");
        float modDur = tags.getFloat("ModDurability");
        int total = Math.max((int)((float)(base + bonus) * (modDur + 1.0f)), 1);
        tags.setInteger("BaseDurability", base);
        tags.setInteger("TotalDurability", total);
        ReplacementLogic.updateTag(newTags, tags, "Attack");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeed");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeed2");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeedHandle");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeedExtra");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevel");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevel2");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevelHandle");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevelExtra");
        ReplacementLogic.updateTag(newTags, tags, "DrawSpeed");
        ReplacementLogic.updateTag(newTags, tags, "BaseDrawSpeed");
        ReplacementLogic.updateTag(newTags, tags, "FlightSpeed");
        ReplacementLogic.updateTag(newTags, tags, "Mass");
        ReplacementLogic.updateTag(newTags, tags, "BreakChance");
        ReplacementLogic.updateTag(newTags, tags, "Accuracy");
        ReplacementLogic.updateTag(newTags, tags, "Shoddy");
        if (tool instanceof IAmmo && (ammo = (IAmmo)tool).getAmmoCount(toolStack) > ammo.getMaxAmmo(toolStack)) {
            ammo.setAmmo(ammo.getMaxAmmo(toolStack), toolStack);
        }
        int currentReinforced = tags.getInteger("Unbreaking");
        int oldReinforced = originalTool.getTagCompound().getCompoundTag("InfiTool").getInteger("Unbreaking");
        int newReinforced = newTags.getInteger("Unbreaking");
        tags.setInteger("Unbreaking", newReinforced += currentReinforced - oldReinforced);
        ReplacementLogic.handleMaterialTraits(tags, oldMaterialId, partMaterialId);
        if (tool == TinkerWeaponry.arrowAmmo && type == PartTypes.HANDLE) {
            if (oldMaterialId == 3 && partMaterialId != 3) {
                if (tags.getInteger("Fiery") > 5) {
                    tags.setInteger("Fiery", tags.getInteger("Fiery") - 5);
                } else {
                    tags.removeTag("Fiery");
                }
            } else if (partMaterialId == 3 && oldMaterialId != 3) {
                tags.setInteger("Fiery", 5);
            }
        }
        ReplacementLogic.reapplyRedstone(tags, toolStack);
        ReplacementLogic.reapplyAttack(tags, toolStack);
        ReplacementLogic.reapplySilktouch(tags, toolStack);
        if (Config.removeMobHeadOnPartReplacement && type == PartTypes.HEAD) {
            ReplacementLogic.removeMobHeadModifier(tags);
        }
        if (tags.hasKey("GemBoost")) {
            tags.removeTag("GemBoost");
        }
        if (!(!PHConstruct.miningLevelIncrease || Config.changeDiamondModifier && TConstruct.pulsar.isPulseLoaded("HarvestLevelTweaks"))) {
            int min = 0;
            if (tags.getBoolean("Diamond")) {
                min = 3;
                if (TConstruct.pulsar.isPulseLoaded("HarvestLevelTweaks")) {
                    min = HarvestLevels._6_obsidian;
                }
            } else if (tags.getBoolean("Emerald")) {
                min = 2;
                if (TConstruct.pulsar.isPulseLoaded("HarvestLevelTweaks")) {
                    min = HarvestLevels._5_diamond;
                }
            }
            if (tags.getInteger("HarvestLevel") < min) {
                tags.setInteger("HarvestLevel", min);
            }
        }
        if (LevelingLogic.hasXp(tags)) {
            float newRequiredXp = LevelingLogic.getRequiredXp(toolStack, tags);
            xp = LevelingLogic.getXp(tags);
            xp *= newRequiredXp / (float)oldRequiredXp;
            if (Config.partReplacementXpPenality > 0) {
                xp *= (100.0f - (float)Config.partReplacementXpPenality) / 100.0f;
            }
            tags.setInteger("ToolEXP", Math.round(xp));
        }
        if (LevelingLogic.hasBoostXp(newTags) && Config.levelingPickaxeBoost) {
            float newRequiredBoostXp = LevelingLogic.getRequiredBoostXp(toolStack);
            xp = LevelingLogic.getBoostXp(tags);
            float percentage = xp / (float)oldRequiredBoostXp;
            xp *= newRequiredBoostXp / (float)oldRequiredBoostXp;
            if (Config.partReplacementBoostXpPenality > 0 && type == PartTypes.HEAD) {
                if (LevelingLogic.isBoosted(tags)) {
                    tags.setBoolean("HarvestLevelModified", false);
                    xp = newRequiredBoostXp;
                }
                xp *= (100.0f - (float)Config.partReplacementBoostXpPenality) / 100.0f;
            }
            tags.setInteger("HeadEXP", Math.round(xp));
            if (LevelingLogic.isBoosted(tags)) {
                tags.setInteger("HarvestLevel", tags.getInteger("HarvestLevel") + 1);
            }
        } else if (IguanaTweaksTConstruct.pulsar.isPulseLoaded("ToolLeveling")) {
            LevelingLogic.addBoostTags(tags, tool);
        }
        if (type == PartTypes.HEAD) {
            String defaultName = ToolBuilder.defaultToolName((ToolMaterial)TConstructRegistry.getMaterial((int)oldMaterialId), (ToolCore)tool);
            if (toolStack.getDisplayName().endsWith(defaultName)) {
                defaultName = ToolBuilder.defaultToolName((ToolMaterial)TConstructRegistry.getMaterial((int)partMaterialId), (ToolCore)tool);
                toolStack.setStackDisplayName("\u00a7r" + defaultName);
            }
        }
    }

    private static void updateTag(NBTTagCompound from, NBTTagCompound to, String tag) {
        if (to.hasKey(tag)) {
            to.setTag(tag, from.getTag(tag));
        }
    }

    private static void handleMaterialTraits(NBTTagCompound tags, int oldMaterialId, int newMaterialId) {
        if (oldMaterialId == newMaterialId) {
            return;
        }
        ToolMaterial oldMat = TConstructRegistry.getMaterial((int)oldMaterialId);
        ToolMaterial newMat = TConstructRegistry.getMaterial((int)newMaterialId);
        String ability = newMat.ability();
        if (newMaterialId == 9 || newMaterialId == 31) {
            tags.setInteger("Modifiers", tags.getInteger("Modifiers") + 1);
        }
        ability = oldMat.ability();
        if (oldMaterialId == 9 || oldMaterialId == 31) {
            int newMods = tags.getInteger("Modifiers") - 1;
            if (newMods < 0) {
                newMods = 0;
            }
            tags.setInteger("Modifiers", newMods);
        }
    }

    private static void reapplyRedstone(NBTTagCompound tags, ItemStack itemStack) {
        if (!tags.hasKey("Redstone")) {
            return;
        }
        int modifiers = tags.getInteger("Modifiers");
        for (ItemModifier mod : ModifyBuilder.instance.itemModifiers) {
            if (!(mod instanceof ModRedstone)) continue;
            ModRedstone modRedstone = (ModRedstone)mod;
            if (modRedstone instanceof ModXpAwareRedstone) {
                modRedstone = ((ModXpAwareRedstone)modRedstone).originalModifier;
            }
            int[] keyPair = tags.getIntArray("Redstone");
            int rLvl = keyPair[0];
            tags.removeTag("Redstone");
            int tipIndex = keyPair[2];
            tags.removeTag("Tooltip" + tipIndex);
            tags.removeTag("ModifierTip" + tipIndex);
            while (rLvl-- > 0) {
                modRedstone.modify(new ItemStack[]{new ItemStack(Items.redstone)}, itemStack);
            }
        }
        tags.setInteger("Modifiers", modifiers);
    }

    private static void reapplyAttack(NBTTagCompound tags, ItemStack itemStack) {
        if (!tags.hasKey("ModAttack")) {
            return;
        }
        int modifiers = tags.getInteger("Modifiers");
        ModAttack modAttack = TinkerTools.modAttack;
        if (itemStack.getItem() instanceof ToolCore && TinkerWeaponry.modAttack != null && Arrays.asList(((ToolCore)itemStack.getItem()).getTraits()).contains("ammo")) {
            modAttack = TinkerWeaponry.modAttack;
        }
        int[] keyPair = tags.getIntArray("ModAttack");
        int qLvl = keyPair[0];
        tags.removeTag("ModAttack");
        int tipIndex = keyPair[2];
        tags.removeTag("Tooltip" + tipIndex);
        tags.removeTag("ModifierTip" + tipIndex);
        while (qLvl-- > 0) {
            modAttack.modify(new ItemStack[]{new ItemStack(Items.quartz)}, itemStack);
        }
        tags.setInteger("Modifiers", modifiers);
    }

    private static void reapplySilktouch(NBTTagCompound tags, ItemStack itemStack) {
        if (!tags.hasKey("Silk Touch")) {
            return;
        }
        int attack = tags.getInteger("Attack");
        if ((attack -= 3) < 0) {
            attack = 0;
        }
        tags.setInteger("Attack", attack);
        int miningSpeed = tags.getInteger("MiningSpeed");
        if ((miningSpeed -= 300) < 0) {
            miningSpeed = 0;
        }
        tags.setInteger("MiningSpeed", miningSpeed);
        if (tags.hasKey("MiningSpeed2")) {
            int miningSpeed2 = tags.getInteger("MiningSpeed2");
            if ((miningSpeed2 -= 300) < 0) {
                miningSpeed2 = 0;
            }
            tags.setInteger("MiningSpeed2", miningSpeed2);
        }
    }

    private static void removeMobHeadModifier(NBTTagCompound tags) {
        if (!tags.hasKey("Mining Level Boost")) {
            return;
        }
        tags.removeTag("Mining Level Boost");
        int i = 1;
        boolean removed = false;
        while (true) {
            String effect = "Effect" + i;
            ++i;
            if (!tags.hasKey(effect)) break;
            if (removed) {
                tags.setInteger("Effect" + (i - 2), tags.getInteger(effect));
                tags.removeTag(effect);
                continue;
            }
            int effectId = tags.getInteger(effect);
            if (effectId < 20 || effectId > 26) continue;
            tags.removeTag(effect);
            removed = true;
        }
        i = 1;
        removed = false;
        while (true) {
            String modTip = "ModifierTip" + i;
            String toolTip = "Tooltip" + i;
            ++i;
            if (!tags.hasKey(modTip)) break;
            if (removed) {
                tags.setString("ModifierTip" + (i - 2), tags.getString(modTip));
                tags.setString("Tooltip" + (i - 2), tags.getString(toolTip));
                tags.removeTag(modTip);
                tags.removeTag(toolTip);
                continue;
            }
            if (!tags.getString(modTip).endsWith("Mining Level Boost")) continue;
            tags.removeTag(modTip);
            tags.removeTag(toolTip);
            removed = true;
        }
        if (Config.mobHeadRequiresModifier) {
            tags.setInteger("Modifiers", tags.getInteger("Modifiers") + 1);
        }
    }

    public static boolean hasExtraModifier(int materialId) {
        return materialId == 9 || materialId == 31;
    }

    public static Item getPart(ToolCore tool, PartTypes type) {
        switch (type) {
            case HEAD: {
                return tool.getHeadItem();
            }
            case HANDLE: {
                return tool.getHandleItem();
            }
            case ACCESSORY: {
                return tool.getAccessoryItem();
            }
            case EXTRA: {
                return tool.getExtraItem();
            }
        }
        return null;
    }

    public static int getToolPartMaterial(NBTTagCompound tags, PartTypes type) {
        int mat = -1;
        switch (type) {
            case HEAD: {
                mat = tags.getInteger("Head");
                break;
            }
            case HANDLE: {
                mat = tags.getInteger("Handle");
                break;
            }
            case ACCESSORY: {
                mat = tags.getInteger("Accessory");
                break;
            }
            case EXTRA: {
                mat = tags.getInteger("Extra");
            }
        }
        return mat;
    }

    public static PartTypes detectAdditionalPartType(ToolRecipe recipe, Item part, PartTypes currentType) {
        PartTypes tmpType = currentType;
        if (tmpType == null) {
            if (recipe.validHead(part)) {
                return PartTypes.HEAD;
            }
            tmpType = PartTypes.HEAD;
        }
        if (tmpType == PartTypes.HEAD) {
            if (recipe.validHandle(part)) {
                return PartTypes.HANDLE;
            }
            tmpType = PartTypes.HANDLE;
        }
        if (tmpType == PartTypes.HANDLE) {
            if (recipe.validAccessory(part)) {
                return PartTypes.ACCESSORY;
            }
            tmpType = PartTypes.ACCESSORY;
        }
        if (tmpType == PartTypes.ACCESSORY && recipe.validExtra(part)) {
            return PartTypes.EXTRA;
        }
        return currentType;
    }

    public static enum PartTypes {
        HEAD,
        HANDLE,
        ACCESSORY,
        EXTRA;

    }
}

