/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.modifiers;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import tconstruct.modifiers.tools.ModBoolean;

public class ModMiningLevelBoost
extends ModBoolean {
    private int maxLvl = 0;

    public ModMiningLevelBoost(ItemStack[] recipe, int effect, int maxLvl) {
        super(recipe, effect, "Mining Level Boost", EnumChatFormatting.GREEN.toString(), recipe[0].getDisplayName());
        this.maxLvl = maxLvl;
    }

    protected boolean canModify(ItemStack input, ItemStack[] recipe) {
        NBTTagCompound tags = input.getTagCompound().getCompoundTag("InfiTool");
        if (Config.mobHeadRequiresModifier && tags.getInteger("Modifiers") <= 0) {
            return false;
        }
        if (tags.getBoolean(this.key)) {
            return false;
        }
        int hlvl = tags.getInteger("HarvestLevel");
        return hlvl < this.maxLvl && LevelingLogic.canBoostMiningLevel(tags);
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        LevelingLogic.levelUpMiningLevel(tool, null, false);
        if (!Config.mobHeadRequiresModifier) {
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
            tags.setInteger("Modifiers", tags.getInteger("Modifiers") + 1);
        }
        super.modify(input, tool);
    }
}

