/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.ConfigCategory;
import iguanaman.hungeroverhaul.config.ConfigOption;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Configuration;

public class IguanaConfig {
    public static final String mainConfigFileName = "HungerOverhaul.cfg";
    public static Configuration mainConfig;
    public static final String blankSlateConfigFileName = "blankslate.cfg";
    public static Configuration blankSlateConfig;
    public static final String defaultConfigFileName = "default.cfg";
    public static Configuration defaultConfig;
    public static final List<ConfigCategory> configCategories;
    public static final List<ConfigOption<?>> configOptions;
    public static final List<ConfigCategory> removedConfigCategories;
    public static final List<ConfigOption<?>> removedConfigOptions;
    public static final ConfigCategory CATEGORY_GETTING_SEEDS;
    public static final ConfigCategory CATEGORY_DELAYS;
    public static final ConfigCategory CATEGORY_HARVESTING;
    public static final ConfigCategory CATEGORY_CUSTOM_FIELD;
    public static final ConfigCategory CATEGORY_DIFFICULTY_SCALING;
    public static final ConfigCategory CATEGORY_FOOD;
    public static final ConfigCategory CATEGORY_HARVESTCRAFT;
    public static final ConfigCategory CATEGORY_HUNGER;
    public static final ConfigCategory CATEGORY_LOW_STATS;
    public static final ConfigCategory CATEGORY_HEALTH;
    @Deprecated
    public static final ConfigCategory CATEGORY_ROTTING;
    @Deprecated
    public static final ConfigCategory CATEGORY_POTION_IDS;
    public static final ConfigOption<Boolean> allSeedsEqualOption;
    public static boolean allSeedsEqual;
    public static final ConfigOption<Boolean> removeTallGrassSeedsOption;
    public static boolean removeTallGrassSeeds;
    public static final ConfigOption<Boolean> modifyHoeUseOption;
    public static boolean modifyHoeUse;
    public static final ConfigOption<Boolean> removeHoeRecipesOption;
    public static boolean removeHoeRecipes;
    public static final ConfigOption<Integer> hoeToolDamageMultiplierOption;
    public static int hoeToolDamageMultiplier;
    public static final ConfigOption<Integer> seedChanceOption;
    public static int seedChance;
    public static final ConfigOption<Integer> noSunlightRegrowthMultiplierOption;
    public static int noSunlightRegrowthMultiplier;
    public static final ConfigOption<Integer> wrongBiomeRegrowthMultiplierOption;
    public static int wrongBiomeRegrowthMultiplier;
    public static final ConfigOption<Integer> wrongBiomeRegrowthMultiplierSugarcaneOption;
    public static int wrongBiomeRegrowthMultiplierSugarcane;
    public static final ConfigOption<Integer> flowerRegrowthMultiplierOption;
    public static int flowerRegrowthMultiplier;
    public static final ConfigOption<Integer> cropRegrowthMultiplierOption;
    public static int cropRegrowthMultiplier;
    public static final ConfigOption<Integer> cactusRegrowthMultiplierOption;
    public static int cactusRegrowthMultiplier;
    public static final ConfigOption<Integer> cocoaRegrowthMultiplierOption;
    public static int cocoaRegrowthMultiplier;
    public static final ConfigOption<Integer> sugarcaneRegrowthMultiplierOption;
    public static int sugarcaneRegrowthMultiplier;
    public static final ConfigOption<Integer> treeCropRegrowthMultiplierOption;
    public static int treeCropRegrowthMultiplier;
    public static final ConfigOption<Integer> saplingRegrowthMultiplierOption;
    public static int saplingRegrowthMultiplier;
    public static final ConfigOption<Integer> netherWartRegrowthMultiplierOption;
    public static int netherWartRegrowthMultiplier;
    public static final ConfigOption<Integer> dryingRackTimeMultiplierOption;
    public static int dryingRackTimeMultiplier;
    public static final ConfigOption<Integer> eggTimeoutMultiplierOption;
    public static int eggTimeoutMultiplier;
    public static final ConfigOption<Integer> breedingTimeoutMultiplierOption;
    public static int breedingTimeoutMultiplier;
    public static final ConfigOption<Integer> childDurationMultiplierOption;
    public static int childDurationMultiplier;
    public static final ConfigOption<Integer> milkedTimeoutOption;
    public static int milkedTimeout;
    public static final ConfigOption<Integer> seedsPerHarvestMinOption;
    public static int seedsPerHarvestMin;
    public static final ConfigOption<Integer> seedsPerHarvestMaxOption;
    public static int seedsPerHarvestMax;
    public static final ConfigOption<Integer> producePerHarvestMinOption;
    public static int producePerHarvestMin;
    public static final ConfigOption<Integer> producePerHarvestMaxOption;
    public static int producePerHarvestMax;
    public static final ConfigOption<Boolean> addCustomVillageFieldOption;
    public static boolean addCustomVillageField;
    public static final ConfigOption<Integer> fieldNormalWeightOption;
    public static int fieldNormalWeight;
    public static final ConfigOption<Integer> fieldReedWeightOption;
    public static int fieldReedWeight;
    public static final ConfigOption<Integer> fieldStemWeightOption;
    public static int fieldStemWeight;
    public static final ConfigOption<Boolean> difficultyScalingOption;
    public static boolean difficultyScaling;
    public static final ConfigOption<Boolean> difficultyScalingBoneMealOption;
    public static boolean difficultyScalingBoneMeal;
    public static final ConfigOption<Boolean> difficultyScalingEffectsOption;
    public static boolean difficultyScalingEffects;
    public static final ConfigOption<Boolean> difficultyScalingHealingOption;
    public static boolean difficultyScalingHealing;
    public static final ConfigOption<Boolean> difficultyScalingHungerOption;
    public static boolean difficultyScalingHunger;
    public static final ConfigOption<Boolean> difficultyScalingRespawnHungerOption;
    public static boolean difficultyScalingRespawnHunger;
    public static final ConfigOption<Boolean> modifyFoodValuesOption;
    public static boolean modifyFoodValues;
    public static final ConfigOption<Boolean> useHOFoodValuesOption;
    public static boolean useHOFoodValues;
    public static final ConfigOption<Boolean> addFoodTooltipsOption;
    public static boolean addFoodTooltips;
    public static final ConfigOption<Boolean> modifyFoodStackSizeOption;
    public static boolean modifyFoodStackSize;
    public static final ConfigOption<Boolean> modifyFoodEatingSpeedOption;
    public static boolean modifyFoodEatingSpeed;
    public static final ConfigOption<Integer> foodStackSizeMultiplierOption;
    public static int foodStackSizeMultiplier;
    @Deprecated
    public static final ConfigOption<Float> modFoodValueDividerOption;
    @Deprecated
    public static int modFoodValueDivider;
    public static final ConfigOption<Float> foodHungerDividerOption;
    public static float foodHungerDivider;
    public static final ConfigOption<Float> foodSaturationDividerOption;
    public static float foodSaturationDivider;
    public static final ConfigOption<Float> foodHungerToSaturationDividerOption;
    public static float foodHungerToSaturationDivider;
    public static final ConfigOption<Boolean> addWellFedEffectOption;
    public static boolean addWellFedEffect;
    public static final ConfigOption<Boolean> addTradesButcherOption;
    public static boolean addTradesButcher;
    public static final ConfigOption<Boolean> addCropTradesFarmerOption;
    public static boolean addTradesFarmer;
    public static final ConfigOption<Boolean> addSaplingTradesFarmerOption;
    public static boolean addSaplingTradesFarmer;
    public static final ConfigOption<Boolean> addHarvestCraftChestLootOption;
    public static boolean addHarvestCraftChestLoot;
    public static final ConfigOption<Integer> chestLootMaxStackSizeOption;
    public static int chestLootMaxStackSize;
    public static final ConfigOption<Integer> chestLootChanceOption;
    public static int chestLootChance;
    public static final ConfigOption<Boolean> foodsUnplantableOption;
    public static boolean foodsUnplantable;
    public static final ConfigOption<Boolean> constantHungerLossOption;
    public static boolean constantHungerLoss;
    public static final ConfigOption<Integer> damageOnStarveOption;
    public static int damageOnStarve;
    public static final ConfigOption<Integer> respawnHungerValueOption;
    public static int respawnHungerValue;
    public static final ConfigOption<Integer> respawnHungerDifficultyModifierOption;
    public static int respawnHungerDifficultyModifier;
    public static final ConfigOption<Boolean> disableHealingHungerDrainOption;
    public static boolean disableHealingHungerDrain;
    public static final ConfigOption<Integer> hungerLossRatePercentageOption;
    public static int hungerLossRatePercentage;
    public static final ConfigOption<Boolean> addGuiTextOption;
    public static boolean addGuiText;
    public static final ConfigOption<Boolean> addLowStatEffectsOption;
    public static boolean addLowStatEffects;
    public static final ConfigOption<Boolean> addLowStatNauseaOption;
    public static boolean addLowStatNausea;
    public static final ConfigOption<Boolean> addLowStatSlownessOption;
    public static boolean addLowStatSlowness;
    public static final ConfigOption<Boolean> addLowStatWeaknessOption;
    public static boolean addLowStatWeakness;
    public static final ConfigOption<Boolean> addLowStatMiningSlowdownOption;
    public static boolean addLowStatMiningSlowdown;
    public static final ConfigOption<Integer> minHungerToHealOption;
    public static int minHungerToHeal;
    public static final ConfigOption<Boolean> foodRegensHealthOption;
    public static boolean foodRegensHealth;
    public static final ConfigOption<Integer> foodHealDividerOption;
    public static int foodHealDivider;
    public static final ConfigOption<Integer> healthRegenRatePercentageOption;
    public static int healthRegenRatePercentage;
    public static final ConfigOption<Integer> lowHealthRegenRateModifierOption;
    public static int lowHealthRegenRateModifier;
    @Deprecated
    public static final ConfigOption<Boolean> addSetHungerCommand;
    @Deprecated
    public static final ConfigOption<Boolean> addSleepHungerLoss;
    @Deprecated
    public static final ConfigOption<Boolean> difficultyScalingSleepHungerLoss;

    public static ConfigCategory addCategory(String name, String comment) {
        return IguanaConfig.putCategoryInList(name, comment, configCategories);
    }

    public static ConfigCategory removeCategory(String name) {
        return IguanaConfig.putCategoryInList(name, "", removedConfigCategories);
    }

    public static ConfigCategory putCategoryInList(String name, String comment, List<ConfigCategory> list) {
        ConfigCategory category = new ConfigCategory(name, comment);
        list.add(category);
        return category;
    }

    public static <T> ConfigOption<T> addOption(ConfigCategory category, String name, T defaultValue, T blankSlate, String comment) {
        return IguanaConfig.addOption(category, name, defaultValue, null, null, blankSlate, comment);
    }

    public static <T> ConfigOption<T> addOption(ConfigCategory category, String name, T defaultValue, T minValue, T maxValue, T blankSlate, String comment) {
        return IguanaConfig.putOptionInList(category, name, defaultValue, minValue, maxValue, blankSlate, comment, configOptions);
    }

    public static <T> ConfigOption<T> removeOption(ConfigCategory category, String name, T defaultValue) {
        return IguanaConfig.putOptionInList(category, name, defaultValue, null, null, null, "", removedConfigOptions);
    }

    public static <T> ConfigOption<T> putOptionInList(ConfigCategory category, String name, T defaultValue, T minValue, T maxValue, T blankSlate, String comment, List<ConfigOption<?>> list) {
        ConfigOption<T> configOption = new ConfigOption<T>(category.name, name, defaultValue, minValue, maxValue, blankSlate, comment);
        list.add(configOption);
        return configOption;
    }

    public static void init(File configDir, File oldConfigFile) {
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (mainConfig == null) {
            File mainConfigFile = new File(configDir, mainConfigFileName);
            if (oldConfigFile.exists()) {
                oldConfigFile.renameTo(mainConfigFile);
            }
            mainConfig = new Configuration(mainConfigFile);
            IguanaConfig.reload(mainConfig);
        }
        if (blankSlateConfig == null) {
            blankSlateConfig = new Configuration(new File(configDir, blankSlateConfigFileName));
            IguanaConfig.generateBlankSlate();
        }
        if (defaultConfig == null) {
            defaultConfig = new Configuration(new File(configDir, defaultConfigFileName));
            IguanaConfig.generateDefault();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("HungerOverhaul")) {
            IguanaConfig.reload(mainConfig);
        }
    }

    public static void generateBlankSlate() {
        blankSlateConfig.addCustomCategoryComment(" ", "This config contains settings that will disable all of the changes that Hunger Overhaul makes.\nIt's intended to serve as a starting point for anyone wanting to only enable a few things and leave everything else untouched.\nTo use, rename this file to HungerOverhaul.cfg (overwriting your current HungerOverhaul.cfg)");
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(blankSlateConfig);
        }
        for (ConfigCategory configCategory : removedConfigCategories) {
            configCategory.remove(blankSlateConfig);
        }
        for (ConfigOption configOption : configOptions) {
            configOption.setToBlankSlate(blankSlateConfig);
        }
        for (ConfigOption configOption : removedConfigOptions) {
            configOption.remove(blankSlateConfig);
        }
        blankSlateConfig.save();
    }

    public static void generateDefault() {
        defaultConfig.addCustomCategoryComment(" ", "This config contains all of the default Hunger Overhaul settings.\nIt's intended to serve as an easy backup for returning to the defaults.\nTo use, rename this file to HungerOverhaul.cfg (overwriting your current HungerOverhaul.cfg)");
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(defaultConfig);
        }
        for (ConfigCategory configCategory : removedConfigCategories) {
            configCategory.remove(defaultConfig);
        }
        for (ConfigOption configOption : configOptions) {
            configOption.setToDefault(defaultConfig);
        }
        for (ConfigOption configOption : removedConfigOptions) {
            configOption.remove(defaultConfig);
        }
        defaultConfig.save();
    }

    public static void reload(Configuration config) {
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(config);
        }
        for (ConfigCategory configCategory : removedConfigCategories) {
            configCategory.remove(config);
        }
        if (config.hasCategory(" ")) {
            config.removeCategory(config.getCategory(" "));
        }
        allSeedsEqual = allSeedsEqualOption.get(config);
        removeHoeRecipes = removeHoeRecipesOption.get(config);
        modifyHoeUse = modifyHoeUseOption.get(config);
        removeTallGrassSeeds = removeTallGrassSeedsOption.get(config);
        seedChance = seedChanceOption.get(config);
        hoeToolDamageMultiplier = hoeToolDamageMultiplierOption.get(config);
        noSunlightRegrowthMultiplier = noSunlightRegrowthMultiplierOption.get(config);
        wrongBiomeRegrowthMultiplier = wrongBiomeRegrowthMultiplierOption.get(config);
        wrongBiomeRegrowthMultiplierSugarcane = wrongBiomeRegrowthMultiplierSugarcaneOption.get(config);
        flowerRegrowthMultiplier = flowerRegrowthMultiplierOption.get(config);
        cropRegrowthMultiplier = cropRegrowthMultiplierOption.get(config);
        sugarcaneRegrowthMultiplier = sugarcaneRegrowthMultiplierOption.get(config);
        cactusRegrowthMultiplier = cactusRegrowthMultiplierOption.get(config);
        cocoaRegrowthMultiplier = cocoaRegrowthMultiplierOption.get(config);
        treeCropRegrowthMultiplier = treeCropRegrowthMultiplierOption.get(config);
        saplingRegrowthMultiplier = saplingRegrowthMultiplierOption.get(config);
        netherWartRegrowthMultiplier = netherWartRegrowthMultiplierOption.get(config);
        dryingRackTimeMultiplier = dryingRackTimeMultiplierOption.get(config);
        eggTimeoutMultiplier = eggTimeoutMultiplierOption.get(config);
        breedingTimeoutMultiplier = breedingTimeoutMultiplierOption.get(config);
        childDurationMultiplier = childDurationMultiplierOption.get(config);
        milkedTimeout = milkedTimeoutOption.get(config);
        seedsPerHarvestMin = seedsPerHarvestMinOption.get(config);
        seedsPerHarvestMax = seedsPerHarvestMaxOption.get(config);
        producePerHarvestMin = producePerHarvestMinOption.get(config);
        producePerHarvestMax = producePerHarvestMaxOption.get(config);
        addCustomVillageField = addCustomVillageFieldOption.get(config);
        fieldNormalWeight = fieldNormalWeightOption.get(config);
        fieldReedWeight = fieldReedWeightOption.get(config);
        fieldStemWeight = fieldStemWeightOption.get(config);
        difficultyScaling = difficultyScalingOption.get(config);
        difficultyScalingBoneMeal = difficultyScalingBoneMealOption.get(config);
        difficultyScalingEffects = difficultyScalingEffectsOption.get(config);
        difficultyScalingHealing = difficultyScalingHealingOption.get(config);
        difficultyScalingHunger = difficultyScalingHungerOption.get(config);
        difficultyScalingRespawnHunger = difficultyScalingRespawnHungerOption.get(config);
        modifyFoodValues = modifyFoodValuesOption.get(config);
        useHOFoodValues = useHOFoodValuesOption.get(config);
        addFoodTooltips = addFoodTooltipsOption.get(config);
        modifyFoodEatingSpeed = modifyFoodEatingSpeedOption.get(config);
        modifyFoodStackSize = modifyFoodStackSizeOption.get(config);
        foodStackSizeMultiplier = foodStackSizeMultiplierOption.get(config);
        float oldFoodValueDividerValue = modFoodValueDividerOption.get(config).floatValue();
        IguanaConfig.foodHungerDividerOption.defaultValue = Float.valueOf(oldFoodValueDividerValue);
        foodHungerDivider = foodHungerDividerOption.get(config).floatValue();
        modFoodValueDivider = (int)foodHungerDivider;
        foodSaturationDivider = foodSaturationDividerOption.get(config).floatValue();
        foodHungerToSaturationDivider = foodHungerToSaturationDividerOption.get(config).floatValue();
        addWellFedEffect = addWellFedEffectOption.get(config);
        addTradesButcher = addTradesButcherOption.get(config);
        addTradesFarmer = addCropTradesFarmerOption.get(config);
        addSaplingTradesFarmer = addSaplingTradesFarmerOption.get(config);
        addHarvestCraftChestLoot = addHarvestCraftChestLootOption.get(config);
        chestLootMaxStackSize = chestLootMaxStackSizeOption.get(config);
        chestLootChance = chestLootChanceOption.get(config);
        foodsUnplantable = foodsUnplantableOption.get(config);
        constantHungerLoss = constantHungerLossOption.get(config);
        damageOnStarve = damageOnStarveOption.get(config);
        respawnHungerValue = respawnHungerValueOption.get(config);
        respawnHungerDifficultyModifier = respawnHungerDifficultyModifierOption.get(config);
        disableHealingHungerDrain = disableHealingHungerDrainOption.get(config);
        hungerLossRatePercentage = hungerLossRatePercentageOption.get(config);
        addGuiText = addGuiTextOption.get(config);
        addLowStatEffects = addLowStatEffectsOption.get(config);
        addLowStatNausea = addLowStatNauseaOption.get(config);
        addLowStatSlowness = addLowStatSlownessOption.get(config);
        addLowStatWeakness = addLowStatWeaknessOption.get(config);
        addLowStatMiningSlowdown = addLowStatMiningSlowdownOption.get(config);
        foodRegensHealth = foodRegensHealthOption.get(config);
        minHungerToHeal = minHungerToHealOption.get(config);
        healthRegenRatePercentage = healthRegenRatePercentageOption.get(config);
        lowHealthRegenRateModifier = lowHealthRegenRateModifierOption.get(config);
        foodHealDivider = foodHealDividerOption.get(config);
        for (ConfigOption<?> configOption : removedConfigOptions) {
            configOption.remove(config);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        configCategories = new ArrayList<ConfigCategory>();
        configOptions = new ArrayList();
        removedConfigCategories = new ArrayList<ConfigCategory>();
        removedConfigOptions = new ArrayList();
        CATEGORY_GETTING_SEEDS = IguanaConfig.addCategory("getting seeds", "Options for obtaining seeds");
        CATEGORY_DELAYS = IguanaConfig.addCategory("delays", "Delays for various obtaining food related activities");
        CATEGORY_HARVESTING = IguanaConfig.addCategory("harvesting", "Options related to drops from crops");
        CATEGORY_CUSTOM_FIELD = IguanaConfig.addCategory("custom field", "Options for enabling and manipulating a custom field in Villages");
        CATEGORY_DIFFICULTY_SCALING = IguanaConfig.addCategory("difficulty scaling", "Options to scale the difficulty of certain elements based on game difficulty");
        CATEGORY_FOOD = IguanaConfig.addCategory("food", "Food related options");
        CATEGORY_HARVESTCRAFT = IguanaConfig.addCategory("harvestcraft", "Options related to HarvestCraft.\n" + EnumChatFormatting.RED + "Only works if HarvestCraft is installed!");
        CATEGORY_HUNGER = IguanaConfig.addCategory("hunger", "Options related to hunger");
        CATEGORY_LOW_STATS = IguanaConfig.addCategory("low stats", "Options for how to handle when the player get low health/hunger");
        CATEGORY_HEALTH = IguanaConfig.addCategory("health", "Options related to health");
        CATEGORY_ROTTING = IguanaConfig.removeCategory("rotting");
        CATEGORY_POTION_IDS = IguanaConfig.removeCategory("potion ids");
        allSeedsEqualOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "allSeedsEqual", true, false, "Each seed has an equal chance to drop (grass drops and via hoes)");
        removeTallGrassSeedsOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "removeTallGrassSeeds", true, false, "Removes seed drops when breaking tall grass");
        modifyHoeUseOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "modifyHoeUse", true, false, "Changes the use of hoes depending on the availability of water");
        removeHoeRecipesOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "removeHoeRecipes", true, false, "Whether wood and stone hoe recipes are removed");
        hoeToolDamageMultiplierOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "hoeToolDamageMultiplier", 5, 1, null, 1, "Multiplier on tool damage taken when a hoe is used ('modifyHoeUse' must be true)");
        seedChanceOption = IguanaConfig.addOption(CATEGORY_GETTING_SEEDS, "seedChance", 20, 0, 100, 20, "Percent chance for seed to drop from hoe use on normal difficulty ('modifyHoeUse' must be true)");
        noSunlightRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "noSunlightRegrowthMultiplier", 2, 0, null, 1, "Multipier on crop growth time without sunlight (1 to disable feature, 0 to make crops only grow in sunlight)");
        wrongBiomeRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "wrongBiomeRegrowthMultiplier", 2, 0, null, 1, "Multipier on crop growth time (except sugarcane) in the wrong biome (1 to disable feature, 0 to make crops only grow in correct biome)");
        wrongBiomeRegrowthMultiplierSugarcaneOption = IguanaConfig.addOption(CATEGORY_DELAYS, "wrongBiomeRegrowthMultiplierSugarcane", 2, 0, null, 1, "Multipier on sugarcane growth time in the wrong biome (1 to disable feature, 0 to make sugarcane only grow in correct biome)");
        flowerRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "flowerRegrowthMultiplier", 1, 0, null, 1, "Multiplier on the time it takes a WeeeFlower crop to grow");
        cropRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "cropRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes a non-tree crop to grow");
        cactusRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "cactusRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes cactus to grow");
        cocoaRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "cocoaRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes cocoa to grow");
        sugarcaneRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "sugarcaneRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes sugarcane to grow");
        treeCropRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "treeCropRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes a tree crop to grow");
        saplingRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "saplingRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes a sapling to grow into a tree");
        netherWartRegrowthMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "netherWartRegrowthMultiplier", 4, 0, null, 1, "Multiplier on the time it takes nether wart to grow");
        dryingRackTimeMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "dryingRackTimeMultiplier", 4, 0, null, 1, "Multiplier on the time it takes food to dry on Tinkers' Construct drying racks");
        eggTimeoutMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "eggTimeoutMultiplier", 4, 0, null, 1, "Multiplier applied to the delay between chicken egg laying");
        breedingTimeoutMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "breedingTimeoutMultiplier", 4, 0, null, 1, "Multiplier applied to the delay between breeding entities");
        childDurationMultiplierOption = IguanaConfig.addOption(CATEGORY_DELAYS, "childDurationMultiplier", 4, 0, null, 1, "Multiplier applied to the delay before children become adults");
        milkedTimeoutOption = IguanaConfig.addOption(CATEGORY_DELAYS, "milkedTimeout", 20, 0, null, 0, "Delay (in minutes) after milking a cow before it can be milked again");
        seedsPerHarvestMinOption = IguanaConfig.addOption(CATEGORY_HARVESTING, "seedsPerHarvestMin", 0, 0, null, 0, "Minimum number of seeds you get when harvesting a non-tree crop");
        seedsPerHarvestMaxOption = IguanaConfig.addOption(CATEGORY_HARVESTING, "seedsPerHarvestMax", 0, 0, null, 0, "Maximum number of seeds you get when harvesting a non-tree crop");
        producePerHarvestMinOption = IguanaConfig.addOption(CATEGORY_HARVESTING, "producePerHarvestMin", 2, 0, null, 2, "Minimum number of produce you get when harvesting a non-tree crop");
        producePerHarvestMaxOption = IguanaConfig.addOption(CATEGORY_HARVESTING, "producePerHarvestMax", 4, 0, null, 4, "Maximum number of produce you get when harvesting a non-tree crop");
        addCustomVillageFieldOption = IguanaConfig.addOption(CATEGORY_CUSTOM_FIELD, "addCustomVillageField", true, false, "Adds a custom field to villages");
        fieldNormalWeightOption = IguanaConfig.addOption(CATEGORY_CUSTOM_FIELD, "fieldNormalWeight", 70, 0, null, 70, "Weighted chance for custom field to contain 'normal' crops");
        fieldReedWeightOption = IguanaConfig.addOption(CATEGORY_CUSTOM_FIELD, "fieldReedWeight", 10, 0, null, 10, "Weighted chance for custom field to contain reeds");
        fieldStemWeightOption = IguanaConfig.addOption(CATEGORY_CUSTOM_FIELD, "fieldStemWeight", 10, 0, null, 10, "Weighted chance for custom field to contain pumpkins/melons");
        difficultyScalingOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScaling", true, false, "Enable/Disable all difficulty scaling effect in one setting");
        difficultyScalingBoneMealOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingBoneMeal", true, false, "Effects of bone meal dependant of difficulty ('difficultyScaling' must be true)");
        difficultyScalingEffectsOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingEffects", true, false, "Negative effects on low health/hunger scale by difficulty ('difficultyScaling' must be true)");
        difficultyScalingHealingOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingHealing", true, false, "Healing rate scales by difficulty ('difficultyScaling' must be true)");
        difficultyScalingHungerOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingHunger", true, false, "Hunger loss rate scales by difficulty ('difficultyScaling' must be true)");
        difficultyScalingRespawnHungerOption = IguanaConfig.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingRespawnHunger", true, false, "Hunger value after respawn is affected by difficulty ('difficultyScaling' must be true)");
        modifyFoodValuesOption = IguanaConfig.addOption(CATEGORY_FOOD, "modifyFoodValues", true, false, "Enables/disables all food value modification");
        useHOFoodValuesOption = IguanaConfig.addOption(CATEGORY_FOOD, "useHOFoodValues", true, false, "Enables/disables Hunger Overhaul manually setting the food values for supported mods ('modifyFoodValues' must be true)");
        addFoodTooltipsOption = IguanaConfig.addOption(CATEGORY_FOOD, "addFoodTooltips", true, false, "Add tooltips to food items showing hints at food value");
        modifyFoodStackSizeOption = IguanaConfig.addOption(CATEGORY_FOOD, "modifyFoodStackSize", true, false, "Changes the stack size of food to be dependant on the food's replenishment value");
        modifyFoodEatingSpeedOption = IguanaConfig.addOption(CATEGORY_FOOD, "modifyFoodEatingSpeed", true, false, "Changes the eating animation speed to be dependant on the food's replenishment value");
        foodStackSizeMultiplierOption = IguanaConfig.addOption(CATEGORY_FOOD, "foodStackSizeMultiplier", 1, 1, null, 1, "Multiplier on the stack size of food ('modifyFoodStackSize' must be true)");
        modFoodValueDividerOption = IguanaConfig.removeOption(CATEGORY_FOOD, "modFoodValueDivider", Float.valueOf(4.0f));
        foodHungerDividerOption = IguanaConfig.addOption(CATEGORY_FOOD, "foodHungerDivider", Float.valueOf(4.0f), Float.valueOf(1.0f), "Food values not manually set (see 'useHOFoodValues') will have their hunger value divided by this ('modifyFoodValues' must be true)");
        foodSaturationDividerOption = IguanaConfig.addOption(CATEGORY_FOOD, "foodSaturationDivider", Float.valueOf(1.0f), Float.valueOf(1.0f), "Food values not manually set (see 'useHOFoodValues') will have their saturation modifier divided by this ('modifyFoodValues' must be true)\nNote: Gets applied after 'foodHungerToSaturationDivider'");
        foodHungerToSaturationDividerOption = IguanaConfig.addOption(CATEGORY_FOOD, "foodHungerToSaturationDivider", Float.valueOf(20.0f), Float.valueOf(0.0f), "Food values not manually set (see 'useHOFoodValues') will have their saturation modifier set to <modified hunger> divided by this ('modifyFoodValues' must be true)\nSet to 0 to disable");
        addWellFedEffectOption = IguanaConfig.addOption(CATEGORY_FOOD, "addWellFedEffect", true, false, "Adds a 'well fed' effect that gives slight health regen");
        addTradesButcherOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "addTradesButcher", true, false, "Add high tier HarvestCraft foods to the items butcher villagers will sell (HarvestCraft)");
        addCropTradesFarmerOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "addCropTradesFarmer", true, false, "Add HarvestCraft crop produce to the items farmer villagers will buy (HarvestCraft)");
        addSaplingTradesFarmerOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "addSaplingTradesFarmer", true, false, "Add HarvestCraft saplings to the items farmer villagers will sell (HarvestCraft)");
        addHarvestCraftChestLootOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "addHarvestCraftChestLoot", true, false, "HarvestCraft items added to dungeon/temple chests (Harvestcraft)");
        chestLootMaxStackSizeOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "chestLootMaxStackSize", 64, 1, null, 64, "Max stack size for food to be found in chests (addHarvestCraftChestLoot must be true)");
        chestLootChanceOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "chestLootChance", 5, 1, null, 5, "Weighted chance for food to be found in chests (addHarvestCraftChestLoot must be true)");
        foodsUnplantableOption = IguanaConfig.addOption(CATEGORY_HARVESTCRAFT, "foodsUnplantable", true, false, "Makes HarvestCraft foods unplantable, meaning seeds are required to plant crops");
        constantHungerLossOption = IguanaConfig.addOption(CATEGORY_HUNGER, "constantHungerLoss", true, false, "You lose hunger (very slowly) at all times");
        damageOnStarveOption = IguanaConfig.addOption(CATEGORY_HUNGER, "damageOnStarve", 200, 2, "Amount of damage you take when hunger hits zero (vanilla default 2)");
        respawnHungerValueOption = IguanaConfig.addOption(CATEGORY_HUNGER, "respawnHungerValue", 20, 0, null, 20, "hunger value set after respawning for peaceful/easy difficulty (vanilla default is 20)");
        respawnHungerDifficultyModifierOption = IguanaConfig.addOption(CATEGORY_HUNGER, "respawnHungerDifficultyModifier", 4, 0, null, 4, "The amount difficulty modifies the hunger value set after respawning  ('difficultyScaling' and 'difficultyScalingRespawnHunger' must be true)");
        disableHealingHungerDrainOption = IguanaConfig.addOption(CATEGORY_HUNGER, "disableHealingHungerDrain", true, false, "Disable the hunger drain when healing that was introduced in vanilla 1.6.2");
        hungerLossRatePercentageOption = IguanaConfig.addOption(CATEGORY_HUNGER, "hungerLossRatePercentage", 100, 0, null, 100, "Speed up or slow down the rate that hunger drops (set to 0 to disable hunger loss)");
        addGuiTextOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addGuiText", true, false, "Shows onscreen text when hunger/health is low");
        addLowStatEffectsOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addLowStatEffects", true, false, "Enables/disables all low hunger/health effects");
        addLowStatNauseaOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addLowStatNausea", true, false, "Nausea effect when hunger is really low ('addLowStatEffects' must be true)");
        addLowStatSlownessOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addLowStatSlowness", true, false, "Slowness effect when health/hunger is low ('addLowStatEffects' must be true)");
        addLowStatWeaknessOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addLowStatWeakness", true, false, "Weakness effect when health/hunger is low ('addLowStatEffects' must be true)");
        addLowStatMiningSlowdownOption = IguanaConfig.addOption(CATEGORY_LOW_STATS, "addLowStatMiningSlowdown", true, false, "Mining slowdown effect when health/hunger is low ('addLowStatEffects' must be true)");
        minHungerToHealOption = IguanaConfig.addOption(CATEGORY_HEALTH, "minHungerToHeal", 7, 0, null, 18, "Minimum hunger level before healing starts (vanilla default is 18)");
        foodRegensHealthOption = IguanaConfig.addOption(CATEGORY_HEALTH, "foodRegensHealth", false, false, "Eating food regenerates health");
        foodHealDividerOption = IguanaConfig.addOption(CATEGORY_HEALTH, "foodHealDivider", 4, 0, null, 4, "Amount of health food restores is the food value divided by this number (foodRegensHealth must be true)");
        healthRegenRatePercentageOption = IguanaConfig.addOption(CATEGORY_HEALTH, "healthRegenRatePercentage", 100, 0, null, 100, "Speed up or slow down the rate that health regenerates (0 to disable regen)");
        lowHealthRegenRateModifierOption = IguanaConfig.addOption(CATEGORY_HEALTH, "lowHealthRegenRateModifier", 5, 0, null, 5, "The lower your health the longer it takes to regen, modify the effect here (lower = less effect)");
        addSetHungerCommand = IguanaConfig.removeOption(CATEGORY_HUNGER, "addSetHungerCommand", true);
        addSleepHungerLoss = IguanaConfig.removeOption(CATEGORY_HUNGER, "addSleepHungerLoss", false);
        difficultyScalingSleepHungerLoss = IguanaConfig.removeOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingSleepHungerLoss", true);
    }
}

