/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.food;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.ItemAndBlockList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;

public class FoodModifier {
    private static HashMap<ItemStack, FoodValues> modifiedFoodValues = new HashMap();
    public static ItemAndBlockList blacklist = new ItemAndBlockList();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void getModifiedFoodValues(FoodEvent.GetFoodValues event) {
        if (!IguanaConfig.modifyFoodValues) {
            return;
        }
        if (blacklist.contains(event.food)) {
            return;
        }
        FoodValues modifiedFoodValues = FoodModifier.lookupModifiedFoodValues(event.food);
        if (modifiedFoodValues != null) {
            event.foodValues = modifiedFoodValues;
        } else {
            int hunger = Math.max(Math.round((float)event.foodValues.hunger / IguanaConfig.foodHungerDivider), 1);
            float saturation = event.foodValues.saturationModifier;
            if (IguanaConfig.foodHungerToSaturationDivider != 0.0f) {
                saturation = (float)hunger / IguanaConfig.foodHungerToSaturationDivider;
            }
            event.foodValues = new FoodValues(hunger, saturation /= IguanaConfig.foodSaturationDivider);
        }
    }

    public static void setModifiedFoodValues(Item item, FoodValues values) {
        modifiedFoodValues.put(new ItemStack(item), values);
    }

    public static void setModifiedFoodValues(ItemStack stack, FoodValues values) {
        modifiedFoodValues.put(stack, values);
    }

    private static FoodValues lookupModifiedFoodValues(ItemStack stack) {
        for (Map.Entry<ItemStack, FoodValues> entry : modifiedFoodValues.entrySet()) {
            if (!stack.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

