/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.PlantGrowthModification;
import iguanaman.hungeroverhaul.util.RandomHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import squeek.applecore.api.plants.PlantGrowthEvent;

public class ModulePlantGrowth {
    private static HashMap<Class<? extends Block>, PlantGrowthModification> plantGrowthModificationsByBlockClass = new HashMap();
    private static HashMap<Block, PlantGrowthModification> plantGrowthModificationsByBlock = new HashMap();

    public static void registerPlantGrowthModifier(Class<? extends Block> blockClass, PlantGrowthModification growthModification) {
        plantGrowthModificationsByBlockClass.put(blockClass, growthModification);
    }

    public static void registerPlantGrowthModifier(Block block, PlantGrowthModification growthModification) {
        plantGrowthModificationsByBlock.put(block, growthModification);
    }

    public static PlantGrowthModification getPlantGrowthModification(Block block) {
        if (block == null) {
            return null;
        }
        PlantGrowthModification growthModification = plantGrowthModificationsByBlock.get(block);
        if (growthModification != null) {
            return growthModification;
        }
        return ModulePlantGrowth.getPlantGrowthModification(block.getClass());
    }

    public static PlantGrowthModification getPlantGrowthModification(Class<? extends Block> blockClass) {
        PlantGrowthModification growthModifier = plantGrowthModificationsByBlockClass.get(blockClass);
        if (growthModifier == null) {
            for (Map.Entry<Class<? extends Block>, PlantGrowthModification> entry : plantGrowthModificationsByBlockClass.entrySet()) {
                if (!entry.getKey().isAssignableFrom(blockClass)) continue;
                return entry.getValue();
            }
        }
        return growthModifier;
    }

    @SubscribeEvent
    public void allowGrowthTick(PlantGrowthEvent.AllowGrowthTick event) {
        float sunlightModifier;
        PlantGrowthModification growthModification = ModulePlantGrowth.getPlantGrowthModification(event.block.getClass());
        if (growthModification == null) {
            return;
        }
        float f = sunlightModifier = !growthModification.needsSunlight || growthModification.needsSunlight && event.world.func_72935_r() && event.world.canBlockSeeTheSky(event.x, event.y, event.z) ? 1.0f : IguanaConfig.noSunlightRegrowthMultiplier;
        if (sunlightModifier == 0.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        float biomeModifier = growthModification.wrongBiomeMultiplier;
        if (!growthModification.biomeGrowthModifiers.isEmpty()) {
            biomeModifier = IguanaConfig.wrongBiomeRegrowthMultiplier;
            BiomeGenBase biome = event.world.getBiomeGenForCoords(event.x, event.z);
            for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                if (!growthModification.biomeGrowthModifiers.containsKey(type)) continue;
                biomeModifier = growthModification.getBiomeGrowthModifier(type);
                break;
            }
        }
        if (biomeModifier == 0.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (RandomHelper.nextFloat(event.random, growthModification.growthTickProbability * biomeModifier * sunlightModifier) >= 1.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }
}

