/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.json;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import squeek.applecore.api.food.FoodValues;

public class Food {
    public String name = "";
    public String oreName = "";
    public int meta = 0;
    public int count = 1;
    public float saturationModifier = 0.0f;
    public int hunger = 0;

    public boolean hasOredictEntry() {
        return this.oreName.isEmpty();
    }

    public ItemStack toItemStack() {
        Block b;
        Item i = (Item)GameData.getItemRegistry().getObject(this.name);
        if (i == null && (b = (Block)GameData.getBlockRegistry().getObject(this.name)) != null) {
            i = Item.func_150898_a((Block)b);
        }
        return i == null ? null : new ItemStack((Item)GameData.getItemRegistry().getObject(this.name), this.count, this.meta);
    }

    public FoodValues toFoodValues() {
        return new FoodValues(this.hunger, this.saturationModifier);
    }

    public static Food fromItemStack(ItemStack is, FoodValues fv) {
        return Food.fromItemStack(is, Float.valueOf(fv.saturationModifier), fv.hunger);
    }

    public static Food fromItemStack(ItemStack is, Float saturationModifier, int hunger) {
        Food fd = new Food();
        fd.name = GameData.getItemRegistry().getNameForObject((Object)is.func_77973_b());
        if (fd.name == null || fd.name.isEmpty()) {
            fd.name = GameData.getBlockRegistry().getNameForObject((Object)is.func_77973_b());
        }
        if (fd.name == null || fd.name.isEmpty()) {
            return null;
        }
        fd.meta = is.func_77952_i();
        fd.count = is.field_77994_a;
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)is);
        if (oreIds.length > 0) {
            fd.oreName = OreDictionary.getOreName((int)oreIds[0]);
        }
        fd.saturationModifier = saturationModifier.floatValue();
        fd.hunger = hunger;
        return fd;
    }
}

