/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.common;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.progwml6.natura.overworld.NaturaOverworld;
import iguanaman.hungeroverhaul.common.RandomHelper;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.natura.helper.NaturaHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class BlockHelper {
    public static List<ItemStack> modifyCropDrops(List<ItemStack> drops, IBlockState state, int minSeeds, int maxSeeds, int minProduce, int maxProduce) {
        ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
        int seeds = RandomHelper.getRandomIntFromRange(minSeeds, maxSeeds);
        int produce = RandomHelper.getRandomIntFromRange(minProduce, maxProduce);
        ItemStack seedItem = BlockHelper.getSeedsOfBlock(state, seeds);
        ItemStack produceItem = BlockHelper.getProduceOfBlock(state, produce);
        boolean produceIsNotSeed = seedItem.func_77973_b() != produceItem.func_77973_b() || seedItem.func_77952_i() != produceItem.func_77952_i();
        for (ItemStack item : drops) {
            if (item.func_77969_a(seedItem) || item.func_77969_a(produceItem)) continue;
            modifiedDrops.add(item);
        }
        if (produceIsNotSeed && seedItem.field_77994_a > 0) {
            modifiedDrops.add(seedItem);
        }
        if (produceItem.field_77994_a > 0) {
            modifiedDrops.add(produceItem);
        }
        return modifiedDrops;
    }

    public static ItemStack getSeedOfBlock(IBlockState state) {
        return BlockHelper.getSeedsOfBlock(state, 1);
    }

    public static ItemStack getSeedsOfBlock(IBlockState state, int num) {
        return new ItemStack(BlockHelper.getSeedItem(state), num, BlockHelper.getSeedMetadata(state));
    }

    public static ItemStack getProduceOfBlock(IBlockState state) {
        return BlockHelper.getProduceOfBlock(state, 1);
    }

    public static ItemStack getProduceOfBlock(IBlockState state, int num) {
        return new ItemStack(BlockHelper.getProduceItem(state), num, BlockHelper.getProduceMetadata(state));
    }

    public static Item getSeedItem(IBlockState state) {
        Item seedForProduct;
        Item itemDropped = state.func_177230_c().func_180660_a(state, RandomHelper.random, 0);
        if (Loader.isModLoaded((String)"natura") && (state.func_177230_c() == NaturaOverworld.barleyCrop || state.func_177230_c() == NaturaOverworld.cottonCrop)) {
            Item seedForProduct2 = NaturaHelper.cropToSeedMap.get(state.func_177230_c());
            if (seedForProduct2 != null) {
                return seedForProduct2;
            }
        } else if (Loader.isModLoaded((String)"harvestcraft") && state.func_177230_c() instanceof BlockPamCrop && (seedForProduct = PamsModsHelper.productToSeedMap.get(itemDropped)) != null) {
            return seedForProduct;
        }
        return itemDropped;
    }

    public static Item getProduceItem(IBlockState state) {
        return state.func_177230_c().func_180660_a(state, RandomHelper.random, 0);
    }

    public static int getProduceMetadata(IBlockState state) {
        return state.func_177230_c().func_180651_a(state);
    }

    public static int getSeedMetadata(IBlockState state) {
        if (Loader.isModLoaded((String)"natura") && state.func_177230_c() == NaturaOverworld.barleyCrop) {
            return NaturaOverworld.barley_seeds.func_77946_l().func_77952_i();
        }
        if (Loader.isModLoaded((String)"natura") && state.func_177230_c() == NaturaOverworld.cottonCrop) {
            return NaturaOverworld.cotton_seeds.func_77946_l().func_77952_i();
        }
        return state.func_177230_c().func_180651_a(state);
    }
}

