/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.json;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import squeek.applecore.api.food.FoodValues;

public class Food {
    public ResourceLocation name;
    public String oreName;
    public int meta = 0;
    public int count = 1;
    public float saturationModifier = 0.0f;
    public int hunger = 0;

    public boolean hasOredictEntry() {
        return this.oreName.isEmpty();
    }

    public ItemStack toItemStack() {
        Block block;
        Item item = (Item)GameData.getItemRegistry().getObject(this.name);
        if (item == null && (block = (Block)GameData.getBlockRegistry().getObject(this.name)) != null) {
            item = Item.getItemFromBlock((Block)block);
        }
        return item == null ? null : new ItemStack((Item)GameData.getItemRegistry().getObject(this.name), this.count, this.meta);
    }

    public FoodValues toFoodValues() {
        return new FoodValues(this.hunger, this.saturationModifier);
    }

    public static Food fromItemStack(ItemStack is, FoodValues fv) {
        return Food.fromItemStack(is, Float.valueOf(fv.saturationModifier), fv.hunger);
    }

    public static Food fromItemStack(ItemStack is, Float saturationModifier, int hunger) {
        Food fd = new Food();
        fd.name = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)is.getItem());
        if (fd.name == null || fd.name.toString().isEmpty()) {
            fd.name = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)Block.getBlockFromItem((Item)is.getItem()));
        }
        if (fd.name == null || fd.name.toString().isEmpty()) {
            return null;
        }
        fd.meta = is.getItemDamage();
        fd.count = is.stackSize;
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)is);
        if (oreIds.length > 0) {
            fd.oreName = OreDictionary.getOreName((int)oreIds[0]);
        }
        fd.saturationModifier = saturationModifier.floatValue();
        fd.hunger = hunger;
        return fd;
    }
}

