/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.CloudGen;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class BaseCloudWorldgen
implements IWorldGenerator {
    CloudGen smallcloud;
    CloudGen mediumcloud;
    CloudGen largecloud;
    CloudGen hugecloud;
    CloudGen smalldarkcloud;
    CloudGen mediumdarkcloud;
    CloudGen largedarkcloud;
    CloudGen hugedarkcloud;
    CloudGen tinyashcloud;
    CloudGen smallashcloud;
    CloudGen mediumashcloud;
    CloudGen largeashcloud;
    CloudGen hugeashcloud;
    CloudGen tinysulfurcloud;
    CloudGen smallsulfurcloud;
    CloudGen mediumsulfurcloud;
    CloudGen largesulfurcloud;
    CloudGen hugesulfurcloud;

    public BaseCloudWorldgen() {
        this.smallcloud = new CloudGen(NContent.cloud.field_71990_ca, 0, 10, false);
        this.mediumcloud = new CloudGen(NContent.cloud.field_71990_ca, 0, 20, false);
        this.largecloud = new CloudGen(NContent.cloud.field_71990_ca, 0, 30, false);
        this.hugecloud = new CloudGen(NContent.cloud.field_71990_ca, 0, 40, false);
        this.smalldarkcloud = new CloudGen(NContent.cloud.field_71990_ca, 1, 10, false);
        this.mediumdarkcloud = new CloudGen(NContent.cloud.field_71990_ca, 1, 20, false);
        this.largedarkcloud = new CloudGen(NContent.cloud.field_71990_ca, 1, 30, false);
        this.hugedarkcloud = new CloudGen(NContent.cloud.field_71990_ca, 1, 40, false);
        this.tinyashcloud = new CloudGen(NContent.cloud.field_71990_ca, 2, 3, false);
        this.smallashcloud = new CloudGen(NContent.cloud.field_71990_ca, 2, 10, false);
        this.mediumashcloud = new CloudGen(NContent.cloud.field_71990_ca, 2, 18, false);
        this.largeashcloud = new CloudGen(NContent.cloud.field_71990_ca, 2, 27, false);
        this.hugeashcloud = new CloudGen(NContent.cloud.field_71990_ca, 2, 37, false);
        this.tinysulfurcloud = new CloudGen(NContent.cloud.field_71990_ca, 3, 3, false);
        this.smallsulfurcloud = new CloudGen(NContent.cloud.field_71990_ca, 3, 10, false);
        this.mediumsulfurcloud = new CloudGen(NContent.cloud.field_71990_ca, 3, 18, false);
        this.largesulfurcloud = new CloudGen(NContent.cloud.field_71990_ca, 3, 27, false);
        this.hugesulfurcloud = new CloudGen(NContent.cloud.field_71990_ca, 3, 37, false);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int size;
        int yCh;
        int zCh;
        int xCh;
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        BiomeGenBase biome = world.func_72959_q().func_76935_a(xChunk + 16, zChunk + 16);
        if (PHNatura.generateOverworldClouds && biome.field_76751_G > 0.15f && random.nextInt(PHNatura.cloudSpawnRarity) == 0 && world.field_73011_w.field_76574_g != 1) {
            xCh = xChunk + random.nextInt(16);
            zCh = zChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.cloudSpawnRange) + PHNatura.cloudSpawnHeight;
            size = random.nextInt(12);
            if (size < 5) {
                this.smallcloud.func_76484_a(world, random, xCh, yCh, zCh);
            } else if (size < 9) {
                this.mediumcloud.func_76484_a(world, random, xCh, yCh, zCh);
            } else if (size < 11) {
                this.largecloud.func_76484_a(world, random, xCh, yCh, zCh);
            } else {
                this.hugecloud.func_76484_a(world, random, xCh, yCh, zCh);
            }
        }
        if (PHNatura.generateDarkClouds && biome == BiomeGenBase.field_76779_k && random.nextInt(4) == 0) {
            xCh = xChunk + random.nextInt(16);
            zCh = zChunk + random.nextInt(16);
            for (int iter = 0; iter < PHNatura.darkCloudSpawnRarity; ++iter) {
                int height = random.nextInt(PHNatura.darkCloudSpawnRange);
                if (random.nextInt(5) == 0) {
                    this.smalldarkcloud.func_76484_a(world, random, xCh, height + PHNatura.darkCloudSpawnHeight, zCh);
                } else if (random.nextInt(7) == 0) {
                    this.mediumcloud.func_76484_a(world, random, xCh, height + PHNatura.darkCloudSpawnHeight, zCh);
                } else if (random.nextInt(9) == 0) {
                    this.largedarkcloud.func_76484_a(world, random, xCh, height + PHNatura.darkCloudSpawnHeight, zCh);
                }
                if (random.nextInt(12) != 0) continue;
                this.hugedarkcloud.func_76484_a(world, random, xCh, height + PHNatura.darkCloudSpawnHeight, zCh);
            }
        }
        if (world.field_73011_w.field_76575_d) {
            if (PHNatura.generateAshClouds && random.nextInt(PHNatura.ashSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.ashSpawnRange) + PHNatura.ashSpawnHeight;
                zCh = zChunk + random.nextInt(16);
                size = random.nextInt(12);
                if (size < 5) {
                    this.tinyashcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else if (size < 9) {
                    this.smallashcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else if (size < 11) {
                    this.largeashcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else {
                    this.hugeashcloud.func_76484_a(world, random, xCh, yCh, zCh);
                }
            }
            if (PHNatura.generateSulfurClouds && random.nextInt(PHNatura.sulfurSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.sulfurSpawnRange) + PHNatura.sulfurSpawnHeight;
                zCh = zChunk + random.nextInt(16);
                size = random.nextInt(12);
                if (size < 5) {
                    this.tinysulfurcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else if (size < 9) {
                    this.smallsulfurcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else if (size < 11) {
                    this.largesulfurcloud.func_76484_a(world, random, xCh, yCh, zCh);
                } else {
                    this.hugesulfurcloud.func_76484_a(world, random, xCh, yCh, zCh);
                }
            }
        }
    }
}

