/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.blocks;

import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;

public abstract class InventoryBlock
extends BlockContainer {
    protected Random rand = new Random();
    int side = -1;
    public Icon[] icons;

    protected InventoryBlock(int id, Material material) {
        super(id, material);
    }

    public TileEntity createNewTileEntity(World var1) {
        return null;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public abstract Integer getGui(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public abstract Object getModInstance();

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.isSneaking()) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        if (!world.isRemote) {
            player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        }
        return true;
    }

    public void breakBlock(World par1World, int x, int y, int z, int blockID, int meta) {
        TileEntity te = par1World.getBlockTileEntity(x, y, z);
        if (te != null && te instanceof InventoryLogic) {
            InventoryLogic logic = (InventoryLogic)te;
            logic.removeBlock();
            for (int iter = 0; iter < logic.getSizeInventory(); ++iter) {
                ItemStack stack = logic.getStackInSlot(iter);
                if (stack == null || !logic.canDropInventorySlot(iter)) continue;
                float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.stackSize > 0) {
                    int itemSize = this.rand.nextInt(21) + 10;
                    if (itemSize > stack.stackSize) {
                        itemSize = stack.stackSize;
                    }
                    stack.stackSize -= itemSize;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), new ItemStack(stack.itemID, itemSize, stack.getItemDamage()));
                    if (stack.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                    }
                    float offset = 0.05f;
                    entityitem.motionX = (float)this.rand.nextGaussian() * offset;
                    entityitem.motionY = (float)this.rand.nextGaussian() * offset + 0.2f;
                    entityitem.motionZ = (float)this.rand.nextGaussian() * offset;
                    par1World.spawnEntityInWorld((Entity)entityitem);
                }
            }
        }
        super.breakBlock(par1World, x, y, z, blockID, meta);
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        this.side = side;
        return meta;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity logic = world.getBlockTileEntity(x, y, z);
        if (logic instanceof IFacingLogic) {
            IFacingLogic direction = (IFacingLogic)logic;
            if (this.side != -1) {
                direction.setDirection(this.side);
                this.side = -1;
            }
            if (entityliving == null) {
                direction.setDirection(0.0f, 0.0f, null);
            } else {
                direction.setDirection(entityliving.rotationYaw * 4.0f, entityliving.rotationPitch, entityliving);
            }
        }
        if (logic instanceof InventoryLogic) {
            InventoryLogic inv = (InventoryLogic)logic;
            inv.placeBlock(entityliving, stack);
            if (stack.hasDisplayName()) {
                inv.setInvName(stack.getDisplayName());
            }
        }
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.getBlockTileEntity(x, y, z);
        if (logic instanceof IActiveLogic) {
            return ((IActiveLogic)logic).getActive();
        }
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public abstract String[] getTextureNames();

    public void registerIcons(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tinker:" + textureNames[i]);
        }
    }
}

