/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BloodTreeLargeGen
extends WorldGenerator {
    private int mdWood;
    private int mdLeaves;

    public BloodTreeLargeGen(int wood, int leaves) {
        this.mdWood = wood;
        this.mdLeaves = leaves;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int height = this.findCeiling(world, x, y, z);
        if (height == -1) {
            return false;
        }
        return this.generateRandomTree(world, random, x, height, z);
    }

    int findCeiling(World world, int x, int y, int z) {
        int ret = -1;
        int height = y;
        do {
            int heightID;
            if ((heightID = world.func_72798_a(x, height, z)) != Block.field_72012_bb.field_71990_ca && heightID != Block.field_72013_bc.field_71990_ca && heightID != NContent.taintedSoil.field_71990_ca || Block.field_71970_n[world.func_72798_a(x, height - 1, z)]) continue;
            ret = height - 1;
            break;
        } while (++height <= 120);
        return ret;
    }

    public boolean generateRandomTree(World world, Random random, int x, int y, int z) {
        int treeHeight = random.nextInt(8) + 8;
        for (int heightIter = 0; heightIter < treeHeight; ++heightIter) {
            int localID = world.func_72798_a(x, y - heightIter, z);
            if (localID != 0 && localID != NContent.floraLeaves.field_71990_ca) continue;
            this.func_76485_a(world, x, y - heightIter, z, NContent.bloodwood.field_71990_ca, 0);
            this.func_76485_a(world, x + 1, y - heightIter, z, NContent.bloodwood.field_71990_ca, 1);
            this.func_76485_a(world, x, y - heightIter, z + 1, NContent.bloodwood.field_71990_ca, 2);
            this.func_76485_a(world, x + 1, y - heightIter, z + 1, NContent.bloodwood.field_71990_ca, 3);
        }
        this.genBranch(world, random, x, y, z, -treeHeight, 1);
        this.genBranch(world, random, x + 1, y, z, -treeHeight, 2);
        this.genBranch(world, random, x, y, z + 1, -treeHeight, 3);
        this.genBranch(world, random, x + 1, y, z + 1, -treeHeight, 4);
        this.genStraightBranch(world, random, x, y, z, -treeHeight, 1);
        this.genStraightBranch(world, random, x + 1, y, z, -treeHeight, 2);
        this.genStraightBranch(world, random, x, y, z + 1, -treeHeight, 3);
        this.genStraightBranch(world, random, x + 1, y, z + 1, -treeHeight, 4);
        return true;
    }

    private void genBranch(World world, Random random, int x, int y, int z, int height, int direction) {
        int xPos = x;
        int yPos = y + height;
        int zPos = z;
        int offsetX = 0;
        int offsetZ = 0;
        switch (direction) {
            case 1: {
                offsetX = 1;
                offsetZ = 1;
                break;
            }
            case 2: {
                offsetX = -1;
                offsetZ = 1;
                break;
            }
            case 3: {
                offsetX = 1;
                offsetZ = -1;
                break;
            }
            case 4: {
                offsetX = -1;
                offsetZ = -1;
            }
        }
        int i2 = random.nextInt(15);
        for (int j2 = 4; j2 > 0; --j2) {
            if (i2 % 3 != 0) {
                xPos += offsetX;
            }
            if (i2 % 3 != 1) {
                zPos += offsetZ;
            }
            this.generateNode(world, random, xPos, yPos += i2 % 3 - 1, zPos);
            i2 = random.nextInt(15);
        }
    }

    private void genStraightBranch(World world, Random random, int x, int y, int z, int height, int direction) {
        int xPos = x;
        int yPos = y + height;
        int zPos = z;
        int offsetX = 0;
        int offsetZ = 0;
        switch (direction) {
            case 1: {
                offsetX = 1;
                offsetZ = 0;
                break;
            }
            case 2: {
                offsetX = 0;
                offsetZ = 1;
                break;
            }
            case 3: {
                offsetX = -1;
                offsetZ = 0;
                break;
            }
            case 4: {
                offsetX = 0;
                offsetZ = -1;
            }
        }
        int i2 = random.nextInt(5);
        for (int j2 = 4; j2 > 0; --j2) {
            if (offsetX == 0) {
                xPos = xPos + random.nextInt(3) - 1;
                zPos += offsetZ;
            }
            if (offsetZ == 0) {
                xPos += offsetX;
                zPos = zPos + random.nextInt(3) - 1;
            }
            this.generateNode(world, random, xPos, yPos -= i2 % 3 - 1, zPos);
            i2 = random.nextInt(5);
        }
    }

    public boolean generateNode(World world, Random random, int x, int y, int z) {
        this.func_76485_a(world, x, y, z, NContent.bloodwood.field_71990_ca, 15);
        for (int l = x - 1; l <= x + 1; ++l) {
            for (int k1 = z - 1; k1 <= z + 1; ++k1) {
                for (int j2 = y - 1; j2 <= y + 1; ++j2) {
                    int i3 = world.func_72798_a(l, j2, k1);
                    if (i3 == NContent.floraLeaves.field_71990_ca || Block.field_71970_n[i3]) continue;
                    this.func_76485_a(world, l, j2, k1, NContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
                }
            }
        }
        for (int i1 = x - 1; i1 <= x + 1; ++i1) {
            for (int l1 = z - 2; l1 <= z + 2; ++l1) {
                int k2 = world.func_72798_a(i1, y, l1);
                if (k2 == NContent.floraLeaves.field_71990_ca || Block.field_71970_n[k2]) continue;
                this.func_76485_a(world, i1, y, l1, NContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
            }
        }
        for (int j1 = x - 2; j1 <= x + 2; ++j1) {
            for (int i2 = z - 1; i2 <= z + 1; ++i2) {
                int l2 = world.func_72798_a(j1, y + 1, i2);
                if (l2 == NContent.floraLeaves.field_71990_ca || Block.field_71970_n[l2]) continue;
                this.func_76485_a(world, j1, y, i2, NContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
            }
        }
        return true;
    }
}

