/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.client.BerryRender;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class NetherBerryBush
extends BlockLeavesBase
implements IPlantable {
    Random random;
    public Icon[] fastIcons;
    public Icon[] fancyIcons;
    public static String[] textureNames = new String[]{"blightberry", "duskberry", "skyberry", "stingberry", "blightberry_ripe", "duskberry_ripe", "skyberry_ripe", "stingberry_ripe"};

    public NetherBerryBush(int id) {
        super(id, Material.field_76257_i, false);
        this.func_71907_b(true);
        this.random = new Random();
        this.func_71848_c(0.3f);
        this.func_71884_a(Block.field_71965_g);
        this.func_71864_b("berrybush");
        this.func_71849_a(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.fastIcons = new Icon[textureNames.length];
        this.fancyIcons = new Icon[textureNames.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            this.fastIcons[i] = iconRegister.func_94245_a("natura:" + textureNames[i] + "_fast");
            this.fancyIcons[i] = iconRegister.func_94245_a("natura:" + textureNames[i] + "_fancy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (this.field_72131_c) {
            if (metadata < 12) {
                return this.fancyIcons[metadata % 4];
            }
            return this.fancyIcons[metadata % 4 + 4];
        }
        if (metadata < 12) {
            return this.fastIcons[metadata % 4];
        }
        return this.fastIcons[metadata % 4 + 4];
    }

    public int func_71899_b(int metadata) {
        return metadata % 4;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public void func_71902_a(IBlockAccess iblockaccess, int x, int y, int z) {
        float maxY;
        float maxX;
        float maxZ;
        float minX;
        float minZ;
        int md = iblockaccess.func_72805_g(x, y, z);
        float minY = 0.0f;
        if (md < 4) {
            minZ = 0.25f;
            minX = 0.25f;
            maxZ = 0.75f;
            maxX = 0.75f;
            maxY = 0.5f;
        } else if (md < 8) {
            minZ = 0.125f;
            minX = 0.125f;
            maxZ = 0.875f;
            maxX = 0.875f;
            maxY = 0.75f;
        } else {
            minZ = 0.0f;
            minX = 0.0f;
            maxZ = 1.0f;
            maxX = 1.0f;
            maxY = 1.0f;
        }
        this.func_71905_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        int meta;
        if (!world.field_72995_K && (meta = world.func_72805_g(x, y, z)) >= 12) {
            world.func_72832_d(x, y, z, this.field_71990_ca, meta - 4, 3);
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, new ItemStack(NContent.netherBerryItem.field_77779_bT, 1, meta - 12));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 12) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_72832_d(x, y, z, this.field_71990_ca, meta - 4, 3);
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, new ItemStack(NContent.netherBerryItem.field_77779_bT, 1, meta - 12));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
            return true;
        }
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void setGraphicsLevel(boolean flag) {
        this.field_72131_c = flag;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return BerryRender.berryModel;
    }

    public boolean func_71877_c(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l > 7 || this.field_72131_c) {
            return super.func_71877_c(iblockaccess, i, j, k, l);
        }
        return true;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random1) {
        if (world.field_72995_K) {
            return;
        }
        int height = 1;
        while (world.func_72798_a(x, y - height, z) == this.field_71990_ca) {
            ++height;
        }
        if (random1.nextInt(75) == 0) {
            int md = world.func_72805_g(x, y, z);
            if (md < 12) {
                world.func_72832_d(x, y, z, this.field_71990_ca, md + 4, 3);
            }
            if (random1.nextInt(3) == 0 && height < 3 && world.func_72798_a(x, y + 1, z) == 0 && md >= 8) {
                world.func_72832_d(x, y + 1, z, this.field_71990_ca, md % 4, 3);
            }
        }
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return false;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 12; var4 < 16; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Nether;
    }

    public int getPlantID(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) - 4;
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if (meta / 4 < 2) {
            if (random.nextBoolean()) {
                int setMeta = random.nextInt(2) + 1 + meta / 4;
                if (setMeta > 2) {
                    setMeta = 2;
                }
                world.func_72921_c(x, y, z, meta % 4 + setMeta * 4, 4);
            }
            return true;
        }
        Block block = Block.field_71973_m[world.func_72798_a(x, y + 1, z)];
        if (block == null || block.isAirBlock(world, x, y + 1, z)) {
            if (random.nextBoolean() && random.nextInt(3) == 0) {
                world.func_72832_d(x, y + 1, z, this.field_71990_ca, meta % 4, 3);
            }
            return true;
        }
        return false;
    }
}

