/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.hasTagCompound()) {
            return false;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        World world = player.worldObj;
        int bID = player.worldObj.getBlockId(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        Block block = Block.blocksList[bID];
        if (block == null || bID < 1) {
            return false;
        }
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        if (hlvl <= tags.getInteger("HarvestLevel")) {
            boolean cancelHarvest = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLivingBase)player)) continue;
                cancelHarvest = true;
            }
            return cancelHarvest;
        }
        world.setBlockToAir(x, y, z);
        if (!player.capabilities.isCreativeMode) {
            this.onBlockDestroyed(stack, world, bID, x, y, z, (EntityLivingBase)player);
        }
        if (!world.isRemote) {
            world.playAuxSFX(2001, x, y, z, bID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.hasTagCompound()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.blockMaterial) continue;
            return this.calculateStrength(tags, block, meta);
        }
        if (MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType()) > 0) {
            return this.calculateStrength(tags, block, meta);
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    float calculateStrength(NBTTagCompound tags, Block block, int meta) {
        float mineSpeed = tags.getInteger("MiningSpeed");
        int heads = 1;
        if (tags.hasKey("MiningSpeed2")) {
            mineSpeed += (float)tags.getInteger("MiningSpeed2");
            ++heads;
        }
        if (tags.hasKey("MiningSpeedHandle")) {
            mineSpeed += (float)tags.getInteger("MiningSpeedHandle");
            ++heads;
        }
        if (tags.hasKey("MiningSpeedExtra")) {
            mineSpeed += (float)tags.getInteger("MiningSpeedExtra");
            ++heads;
        }
        float trueSpeed = mineSpeed / ((float)heads * 100.0f);
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        int durability = tags.getInteger("Damage");
        float stonebound = tags.getFloat("Shoddy");
        float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
        trueSpeed += bonusLog;
        if (hlvl <= tags.getInteger("HarvestLevel")) {
            return trueSpeed;
        }
        return 0.1f;
    }

    public boolean canHarvestBlock(Block block) {
        if (block.blockMaterial.isToolNotRequired()) {
            return true;
        }
        for (Material m : this.getEffectiveMaterials()) {
            if (m != block.blockMaterial) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();
}

