/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.entity.BabyHeatscarSpider;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class HeatscarSpider
extends EntitySpider {
    public HeatscarSpider(World par1World) {
        super(par1World);
        this.setSize(2.7f, 1.9f);
        this.isImmuneToFire = true;
        this.experienceValue = 25;
    }

    @SideOnly(value=Side.CLIENT)
    public float spiderScaleAmount() {
        return 2.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.getEntityAttribute(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.getEntityAttribute(SharedMonsterAttributes.field_111263_d).func_111128_a(1.35);
        this.getEntityAttribute(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70785_a(Entity par1Entity, float par2) {
        if (par2 > 2.0f && par2 < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d0 = par1Entity.field_70165_t - this.posX;
                double d1 = par1Entity.field_70161_v - this.posZ;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.motionX = d0 / (double)f2 * 0.5 + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f2 * 0.5 + this.motionZ * (double)0.2f;
                this.motionY = 0.62;
            }
        } else {
            super.func_70785_a(par1Entity, par2);
        }
    }

    public void jump() {
        this.motionY = 0.62;
        if (this.isPotionActive(Potion.field_76430_j)) {
            this.motionY += (double)((float)(this.getActivePotionEffect(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.rotationYaw * ((float)Math.PI / 180);
            this.motionX -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.motionZ += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.isAirBorne = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void fall(float par1) {
        if ((par1 = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)par1)) <= 0.0f) {
            return;
        }
        super.fall(par1);
        int i = MathHelper.func_76123_f((float)(par1 - 5.0f));
        if (i > 0) {
            if (i > 4) {
                this.playSound("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.playSound("damage.fallsmall", 1.0f, 1.0f);
            }
            this.attackEntityFrom(DamageSource.field_76379_h, i);
            int j = this.worldObj.func_72798_a(MathHelper.func_76128_c((double)this.posX), MathHelper.func_76128_c((double)(this.posY - (double)0.2f - (double)this.yOffset)), MathHelper.func_76128_c((double)this.posZ));
            if (j > 0) {
                StepSound stepsound = Block.field_71973_m[j].field_72020_cn;
                this.playSound(stepsound.func_72675_d(), stepsound.func_72677_b() * 0.5f, stepsound.func_72678_c() * 0.75f);
            }
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (super.attackEntityAsMob(par1Entity)) {
            if (par1Entity instanceof EntityLiving) {
                int b0 = 0;
                if (this.worldObj.field_73013_u > 1) {
                    if (this.worldObj.field_73013_u == 2) {
                        b0 = 5;
                    } else if (this.worldObj.field_73013_u == 3) {
                        b0 = 10;
                    }
                }
                if (b0 > 0) {
                    par1Entity.func_70015_d(b0);
                }
            }
            return true;
        }
        return false;
    }

    public int getAttackStrength(Entity par1Entity) {
        return 4;
    }

    protected int func_70633_aT() {
        return NContent.plantItem.field_77779_bT;
    }

    public EntityItem dropItemWithOffset(int par1, int par2, float par3) {
        return this.entityDropItem(new ItemStack(par1, par2, 7), par3);
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.func_70633_aT();
        if (j > 0) {
            int k = this.rand.nextInt(3) + 2;
            if (par2 > 0) {
                k += this.rand.nextInt(par2 + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.dropItem(j, 1);
            }
        }
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.field_73013_u > 0 && this.worldObj.func_72855_b(this.boundingBox) && this.worldObj.func_72945_a((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.func_72953_d(this.boundingBox);
    }

    protected BabyHeatscarSpider createBabyInstance() {
        return new BabyHeatscarSpider(this.worldObj);
    }

    public void setDead() {
        if (!this.worldObj.field_72995_K) {
            int num = PHNatura.babyHeatscarMaximum - PHNatura.babyHeatscarMinimum + 1;
            int amount = this.rand.nextInt(num) + PHNatura.babyHeatscarMinimum;
            for (int i = 0; i < amount; ++i) {
                double f = this.rand.nextDouble() * 2.0;
                double f1 = this.rand.nextDouble() * 2.0;
                BabyHeatscarSpider babyspider = this.createBabyInstance();
                babyspider.setLocationAndAngles(this.posX + f, this.posY + 0.5, this.posZ + f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.func_72838_d((Entity)babyspider);
            }
        }
        super.setDead();
    }
}

