/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import appeng.api.IAEItemStack;
import appeng.api.me.items.IAEChargeableItem;
import appeng.api.me.items.IStorageCell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IBoxable;
import ic2.api.item.ICustomElectricItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.OffhandAttackEvent;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolMaterial;

public abstract class ToolCore
extends Item
implements ICustomElectricItem,
IBoxable,
IBattlegearWeapon,
IStorageCell,
IAEChargeableItem {
    protected Random random = new Random();
    protected int damageVsEntity;
    public static Icon blankSprite;
    public static Icon emptyIcon;
    public HashMap<Integer, Icon> headIcons = new HashMap();
    public HashMap<Integer, Icon> brokenIcons = new HashMap();
    public HashMap<Integer, Icon> handleIcons = new HashMap();
    public HashMap<Integer, Icon> accessoryIcons = new HashMap();
    public HashMap<Integer, Icon> effectIcons = new HashMap();
    public HashMap<Integer, Icon> extraIcons = new HashMap();
    public HashMap<Integer, String> headStrings = new HashMap();
    public HashMap<Integer, String> brokenPartStrings = new HashMap();
    public HashMap<Integer, String> handleStrings = new HashMap();
    public HashMap<Integer, String> accessoryStrings = new HashMap();
    public HashMap<Integer, String> effectStrings = new HashMap();
    public HashMap<Integer, String> extraStrings = new HashMap();

    public ToolCore(int id, int baseDamage) {
        super(id);
        this.maxStackSize = 1;
        this.setMaxDamage(100);
        this.setUnlocalizedName("InfiTool");
        this.setCreativeTab(TConstructRegistry.toolTab);
        this.damageVsEntity = baseDamage;
        TConstructRegistry.addToolMapping(this);
        this.setNoRepair();
        this.canRepair = false;
    }

    public int durabilityTypeHandle() {
        return 1;
    }

    public int durabilityTypeAccessory() {
        return 0;
    }

    public int durabilityTypeExtra() {
        return 0;
    }

    public int getModifierAmount() {
        return 3;
    }

    public String getToolName() {
        return this.getClass().getSimpleName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 9;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack) {
        return false;
    }

    public int getPartAmount() {
        return 3;
    }

    public abstract String getIconSuffix(int var1);

    public abstract String getEffectSuffix();

    public abstract String getDefaultFolder();

    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.brokenPartStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
        if (location.length > 3) {
            this.accessoryStrings.put(index, location[3]);
        }
        if (location.length > 4) {
            this.extraStrings.put(index, location[4]);
        }
    }

    public void registerAlternatePartPaths(int index, String[] location) {
    }

    public void registerEffectPath(int index, String location) {
        this.effectStrings.put(index, location);
    }

    public void registerIcons(IconRegister iconRegister) {
        this.headIcons.clear();
        this.brokenIcons.clear();
        this.handleIcons.clear();
        this.accessoryIcons.clear();
        this.extraIcons.clear();
        this.effectIcons.clear();
        for (Map.Entry<Integer, String> pairs : this.headStrings.entrySet()) {
            this.headIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
        }
        for (Map.Entry<Integer, String> pairs : this.brokenPartStrings.entrySet()) {
            this.brokenIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
        }
        for (Map.Entry<Integer, String> pairs : this.handleStrings.entrySet()) {
            this.handleIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
        }
        if (this.getPartAmount() > 2) {
            for (Map.Entry<Integer, String> pairs : this.accessoryStrings.entrySet()) {
                this.accessoryIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
            }
        }
        if (this.getPartAmount() > 3) {
            for (Map.Entry<Integer, String> pairs : this.extraStrings.entrySet()) {
                this.extraIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
            }
        }
        for (Map.Entry<Integer, String> pairs : this.effectStrings.entrySet()) {
            this.effectIcons.put(pairs.getKey(), iconRegister.registerIcon(pairs.getValue()));
        }
        emptyIcon = iconRegister.registerIcon("tinker:blankface");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIconFromDamage(int meta) {
        return blankSprite;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return this.handleIcons.get(tags.getInteger("RenderHandle"));
                }
                if (renderPass == 1) {
                    if (tags.getBoolean("Broken")) {
                        return this.brokenIcons.get(tags.getInteger("RenderHead"));
                    }
                    return this.headIcons.get(tags.getInteger("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.accessoryIcons.get(tags.getInteger("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.extraIcons.get(tags.getInteger("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.hasKey("Effect1")) {
                    return this.effectIcons.get(tags.getInteger("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.hasKey("Effect2")) {
                    return this.effectIcons.get(tags.getInteger("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.hasKey("Effect3")) {
                    return this.effectIcons.get(tags.getInteger("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.hasKey("Effect4")) {
                    return this.effectIcons.get(tags.getInteger("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.hasKey("Effect5")) {
                    return this.effectIcons.get(tags.getInteger("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5 && tags.hasKey("Effect6")) {
                return this.effectIcons.get(tags.getInteger("Effect6"));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.hasKey("charge")) {
            String color = "";
            int power = tags.getInteger("charge");
            if (power != 0) {
                color = power <= this.getMaxCharge(stack) / 3 ? "\u00a74" : (power > this.getMaxCharge(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String charge = color + tags.getInteger("charge") + "/" + this.getMaxCharge(stack) + " EU";
            list.add(charge);
        }
        if (tags.hasKey("InfiTool")) {
            boolean broken = tags.getCompoundTag("InfiTool").getBoolean("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                int unbreaking;
                String reinforced;
                String extraName;
                String bindingName;
                String handleName;
                int head = tags.getCompoundTag("InfiTool").getInteger("Head");
                int handle = tags.getCompoundTag("InfiTool").getInteger("Handle");
                int binding = tags.getCompoundTag("InfiTool").getInteger("Accessory");
                int extra = tags.getCompoundTag("InfiTool").getInteger("Extra");
                String headName = this.getAbilityNameForType(head);
                if (!headName.equals("")) {
                    list.add(ToolCore.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getAbilityNameForType(handle)).equals("") && handle != head) {
                    list.add(ToolCore.getStyleForType(handle) + handleName);
                }
                if (this.getPartAmount() >= 3 && !(bindingName = this.getAbilityNameForType(binding)).equals("") && binding != head && binding != handle) {
                    list.add(ToolCore.getStyleForType(binding) + bindingName);
                }
                if (this.getPartAmount() >= 4 && !(extraName = this.getAbilityNameForType(extra)).equals("") && extra != head && extra != handle && extra != binding) {
                    list.add(ToolCore.getStyleForType(extra) + extraName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, binding, extra, unbreaking = tags.getCompoundTag("InfiTool").getInteger("Unbreaking"))).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.getCompoundTag("InfiTool").hasKey(tooltip)) {
                        String tipName = tags.getCompoundTag("InfiTool").getString(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
    }

    public static String getStyleForType(int type) {
        return TConstructRegistry.getMaterial(type).style();
    }

    public String getAbilityNameForType(int type) {
        return TConstructRegistry.getMaterial(type).ability();
    }

    public String getReinforcedName(int head, int handle, int accessory, int extra, int unbreaking) {
        ToolMaterial headMat = TConstructRegistry.getMaterial(head);
        ToolMaterial handleMat = TConstructRegistry.getMaterial(handle);
        ToolMaterial accessoryMat = TConstructRegistry.getMaterial(accessory);
        ToolMaterial extraMat = TConstructRegistry.getMaterial(extra);
        int reinforced = 0;
        String style = "";
        int current = headMat.reinforced();
        if (current > 0) {
            style = headMat.style();
            reinforced = current;
        }
        if ((current = handleMat.reinforced()) > 0 && current > reinforced) {
            style = handleMat.style();
            reinforced = current;
        }
        if (this.getPartAmount() >= 3 && (current = accessoryMat.reinforced()) > 0 && current > reinforced) {
            style = accessoryMat.style();
            reinforced = current;
        }
        if (this.getPartAmount() >= 4 && (current = extraMat.reinforced()) > 0 && current > reinforced) {
            style = extraMat.style();
            reinforced = current;
        }
        if ((reinforced += unbreaking - reinforced) > 0) {
            return style + this.getReinforcedString(reinforced);
        }
        return "";
    }

    String getReinforcedString(int reinforced) {
        if (reinforced > 9) {
            return "Unbreakable";
        }
        String ret = "Reinforced ";
        switch (reinforced) {
            case 1: {
                ret = ret + "I";
                break;
            }
            case 2: {
                ret = ret + "II";
                break;
            }
            case 3: {
                ret = ret + "III";
                break;
            }
            case 4: {
                ret = ret + "IV";
                break;
            }
            case 5: {
                ret = ret + "V";
                break;
            }
            case 6: {
                ret = ret + "VI";
                break;
            }
            case 7: {
                ret = ret + "VII";
                break;
            }
            case 8: {
                ret = ret + "VIII";
                break;
            }
            case 9: {
                ret = ret + "IX";
                break;
            }
            default: {
                ret = ret + "X";
            }
        }
        return ret;
    }

    public void onEntityDamaged(World world, EntityLivingBase player, Entity entity) {
    }

    public void getSubItems(int id, CreativeTabs tab, List list) {
        for (Map.Entry<Integer, ToolMaterial> pairs : TConstructRegistry.toolMaterials.entrySet()) {
            ToolMaterial material = pairs.getValue();
            this.buildTool(pairs.getKey(), material.displayName, list);
        }
    }

    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(extra, 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name + this.getToolName());
        if (tool == null) {
            System.out.println("Creative builder failed tool for " + name + this.getToolName());
            System.out.println("Make sure you do not have item ID conflicts");
        } else {
            tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
            list.add(tool);
        }
    }

    public abstract Item getHeadItem();

    public abstract Item getAccessoryItem();

    public Item getExtraItem() {
        return null;
    }

    public Item getHandleItem() {
        return TConstructRegistry.getItem("toolRod");
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            mod.updateTool(this, stack, world, entity);
        }
    }

    public abstract String[] toolCategories();

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        boolean cancelHarvest = false;
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLivingBase)player)) continue;
            cancelHarvest = true;
        }
        return cancelHarvest;
    }

    public boolean onBlockDestroyed(ItemStack itemstack, World world, int blockID, int x, int y, int z, EntityLivingBase player) {
        Block block = Block.blocksList[blockID];
        if (block != null && (double)block.getBlockHardness(world, x, y, z) != 0.0) {
            return AbilityHelper.onBlockChanged(itemstack, world, blockID, x, y, z, player, this.random);
        }
        return true;
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.getCompoundTag("InfiTool").getBoolean("Broken")) {
            return 0.1f;
        }
        return 1.0f;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, entity, this, 0);
        return false;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        return true;
    }

    public boolean pierceArmor() {
        return false;
    }

    public float chargeAttack() {
        return 1.0f;
    }

    public int getDamageVsEntity(Entity par1Entity) {
        return this.damageVsEntity;
    }

    public float getDurabilityModifier() {
        return 1.0f;
    }

    public float getRepairCost() {
        return this.getDurabilityModifier();
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        int posX = x;
        int posY = y;
        int posZ = z;
        int playerPosX = (int)Math.floor(player.posX);
        int playerPosY = (int)Math.floor(player.posY);
        int playerPosZ = (int)Math.floor(player.posZ);
        if (side == 0) {
            --posY;
        }
        if (side == 1) {
            ++posY;
        }
        if (side == 2) {
            --posZ;
        }
        if (side == 3) {
            ++posZ;
        }
        if (side == 4) {
            --posX;
        }
        if (side == 5) {
            ++posX;
        }
        if (posX == playerPosX && (posY == playerPosY || posY == playerPosY + 1 || posY == playerPosY - 1) && posZ == playerPosZ) {
            return false;
        }
        boolean used = false;
        int hotbarSlot = player.inventory.currentItem;
        int itemSlot = hotbarSlot == 0 ? 8 : hotbarSlot + 1;
        ItemStack nearbyStack = null;
        if (hotbarSlot < 8 && (nearbyStack = player.inventory.getStackInSlot(itemSlot)) != null && nearbyStack.getItem() instanceof ItemBlock) {
            used = nearbyStack.getItem().onItemUse(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
            if (nearbyStack.stackSize < 1) {
                nearbyStack = null;
                player.inventory.setInventorySlotContents(itemSlot, null);
            }
        }
        return used;
    }

    public boolean isItemTool(ItemStack par1ItemStack) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isFull3D() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        if (tags.hasKey("charge") && (charge = tags.getInteger("charge")) > 0) {
            return this.getMaxCharge(stack);
        }
        return tags.getCompoundTag("InfiTool").getInteger("TotalDurability");
    }

    public int getItemDamageFromStackForDisplay(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        if (tags.hasKey("charge") && (charge = tags.getInteger("charge")) > 0) {
            return this.getMaxCharge(stack) - charge;
        }
        return tags.getCompoundTag("InfiTool").getInteger("Damage");
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.itemID;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.itemID;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        if (!tags.hasKey("charge")) {
            return 0;
        }
        return 10000;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        if (!tags.hasKey("charge")) {
            return 0;
        }
        return 32;
    }

    @Override
    public int charge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.getTagCompound();
        if (!tags.hasKey("charge")) {
            return 0;
        }
        if (amount > 0) {
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            int charge = tags.getInteger("charge");
            if (amount > this.getMaxCharge(stack) - charge) {
                amount = this.getMaxCharge(stack) - charge;
            }
            charge += amount;
            if (!simulate) {
                tags.setInteger("charge", charge);
                stack.setItemDamage(1 + (this.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 2) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null || !tags.hasKey("charge")) {
            return 0;
        }
        if (amount > 0) {
            int charge;
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            if (amount > (charge = tags.getInteger("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.setInteger("charge", charge);
                stack.setItemDamage(1 + (this.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 1) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return false;
    }

    @Override
    public boolean willAllowOffhandWeapon() {
        return true;
    }

    @Override
    public boolean willAllowShield() {
        return true;
    }

    @Override
    public boolean isOffhandHandDualWeapon() {
        return true;
    }

    @Override
    public boolean sheatheOnBack() {
        return false;
    }

    @Override
    public boolean offhandAttackEntity(OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Override
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Override
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Override
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Override
    public float addEnergy(ItemStack target, float energy) {
        return 0.0f;
    }

    @Override
    public boolean isChargeable(ItemStack it) {
        return false;
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 0;
    }

    @Override
    public int BytePerType(ItemStack cellItem) {
        return 0;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 0;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requsetedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }
}

