/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.blocks;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class InventoryLogic
extends TileEntity
implements IInventory {
    protected ItemStack[] inventory;
    protected String invName;

    public InventoryLogic(int invSize) {
        this.inventory = new ItemStack[invSize];
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canDropInventorySlot(int slot) {
        return true;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].stackSize <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].splitStack(quantity);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistance((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public abstract Container getGuiContainer(InventoryPlayer var1, World var2, int var3, int var4, int var5);

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.readInventoryFromNBT(tags);
    }

    public void readInventoryFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.invName = tags.getString("InvName");
        NBTTagList nbttaglist = tags.getTagList("Items");
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int iter = 0; iter < nbttaglist.tagCount(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)nbttaglist.tagAt(iter);
            byte slotID = tagList.getByte("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagList);
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        this.writeInventoryToNBT(tags);
    }

    public void writeInventoryToNBT(NBTTagCompound tags) {
        if (this.invName != null) {
            tags.setString("InvName", this.invName);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.inventory.length; ++iter) {
            if (this.inventory[iter] == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.setByte("Slot", (byte)iter);
            this.inventory[iter].writeToNBT(tagList);
            nbttaglist.appendTag((NBTBase)tagList);
        }
        tags.setTag("Items", (NBTBase)nbttaglist);
    }

    public void superReadFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
    }

    public void superWriteToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    protected abstract String getDefaultName();

    public void setInvName(String name) {
        this.invName = name;
    }

    public String getInvName() {
        return this.isInvNameLocalized() ? this.invName : this.getDefaultName();
    }

    public boolean isInvNameLocalized() {
        return this.invName != null && this.invName.length() > 0;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return slot < this.getSizeInventory() && (this.inventory[slot] == null || itemstack.stackSize + this.inventory[slot].stackSize <= this.getInventoryStackLimit());
    }

    public void placeBlock(EntityLivingBase entity, ItemStack stack) {
    }

    public void removeBlock() {
    }
}

