/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import ic2.api.item.IBoxable;
import ic2.api.item.ICustomElectricItem;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tconstruct.library.armor.BehaviorDispenseArmorCopy;
import tconstruct.library.armor.EnumArmorPart;

public abstract class ArmorCore
extends ItemArmor
implements ICustomElectricItem,
IBoxable,
ISpecialArmor {
    public static final String SET_NAME = "InfiArmor";
    public final EnumArmorPart armorPart;
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDispenseArmorCopy();
    public final int baseProtection;

    public ArmorCore(int par1, int baseProtection, EnumArmorPart part) {
        super(par1, EnumArmorMaterial.CHAIN, 0, 0);
        this.maxStackSize = 1;
        this.setMaxDamage(100);
        this.setUnlocalizedName(SET_NAME);
        this.armorPart = part;
        this.baseProtection = baseProtection;
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)dispenserBehavior);
    }

    public String getArmorName() {
        return this.getClass().getSimpleName();
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int i = EntityLiving.getArmorPosition((ItemStack)par1ItemStack) - 1;
        ItemStack itemstack1 = par3EntityPlayer.getCurrentArmor(i);
        if (itemstack1 == null) {
            par3EntityPlayer.setCurrentItemOrArmor(i + 1, par1ItemStack.copy());
            par1ItemStack.stackSize = 0;
        }
        return par1ItemStack;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        NBTTagCompound tags = armor.getTagCompound();
        if (tags == null) {
            return new ISpecialArmor.ArmorProperties(0, damage / (double)this.baseProtection, this.baseProtection);
        }
        NBTTagCompound data = tags.getCompoundTag(SET_NAME);
        return new ISpecialArmor.ArmorProperties(0, (double)data.getInteger("damageReduction") / damage, data.getInteger("maxAbsorb"));
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return armor.getTagCompound() != null && armor.getTagCompound().getCompoundTag(SET_NAME) != null ? armor.getTagCompound().getCompoundTag(SET_NAME).getInteger("maxAbsorb") : this.baseProtection;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound data;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.setTagCompound(tags);
            data = new NBTTagCompound();
            tags.setCompoundTag(SET_NAME, data);
            data.setInteger("damageReduction", this.baseProtection);
            data.setInteger("maxAbsorb", this.baseProtection);
        }
        data = tags.getCompoundTag(SET_NAME);
        if (tags.hasKey("charge")) {
            int charge = tags.getInteger("charge");
            if (charge > damage) {
                tags.setInteger("charge", charge -= damage);
                return;
            }
            tags.setInteger("charge", 0);
            int dmg = data.getInteger("Damage");
            data.setInteger("Damage", dmg += (damage -= charge));
        } else {
            int dmg = data.getInteger("Damage");
            data.setInteger("Damage", dmg += damage);
        }
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        return tags.hasKey("charge");
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.itemID;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.itemID;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        return tags.hasKey("charge") ? 10000 : 0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 0;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        return tags.hasKey("charge") ? 32 : 0;
    }

    @Override
    public int charge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.getTagCompound();
        if (!tags.hasKey("charge")) {
            return 0;
        }
        if (amount > 0) {
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            int charge = tags.getInteger("charge");
            if (amount > this.getMaxCharge(stack)) {
                amount = this.getMaxCharge(stack);
            }
            charge += amount;
            if (!simulate) {
                tags.setInteger("charge", charge);
                stack.setItemDamage(1 + (this.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 2) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.getTagCompound();
        if (!tags.hasKey("charge")) {
            return 0;
        }
        if (amount > 0) {
            int charge;
            if (amount > this.getTransferLimit(stack)) {
                amount = this.getTransferLimit(stack);
            }
            if (amount > (charge = tags.getInteger("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.setInteger("charge", charge);
                stack.setItemDamage(1 + (this.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 1) / this.getMaxCharge(stack));
            }
            return charge;
        }
        return 0;
    }

    @Override
    public boolean canUse(ItemStack stack, int amount) {
        return false;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack stack) {
        return false;
    }

    public boolean isItemTool(ItemStack par1ItemStack) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isFull3D() {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.armorPart.getPartId() == armorType;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        if (tags.hasKey("charge") && (charge = tags.getInteger("charge")) > 0) {
            return this.getMaxCharge(stack);
        }
        return tags.getCompoundTag(SET_NAME).getInteger("TotalDurability");
    }

    public int getItemMaxDamageFromStackForDisplay(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        if (tags.hasKey("charge") && (charge = tags.getInteger("charge")) > 0) {
            return this.getMaxCharge(stack) - charge;
        }
        return tags.getCompoundTag(SET_NAME).getInteger("Damage");
    }
}

