/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class BerryBushItem
extends ItemBlock {
    public static final String[] blockType = new String[]{"rasp", "blue", "black", "geo", "rasp", "blue", "black", "geo", "rasp", "blue", "black", "geo", "rasp", "blue", "black", "geo"};

    public BerryBushItem(int i) {
        super(i);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int meta) {
        return meta % 4;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            Block block = Block.blocksList[world.getBlockId(x, y, z)];
            if (block != null && block.canSustainPlant(world, x, y, z, ForgeDirection.UP, (IPlantable)NContent.berryBush) && world.isAirBlock(x, y + 1, z)) {
                world.setBlock(x, y + 1, z, NContent.berryBush.blockID, stack.getItemDamage() % 4, 3);
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
                if (!world.isRemote) {
                    world.playAuxSFX(2001, x, y, z, NContent.berryBush.blockID);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "block." + blockType[itemstack.getItemDamage()] + "berryBush";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (stack.getItemDamage() % 4) {
            case 0: {
                list.add("Sweet and red");
                list.add("Found in warm areas");
                break;
            }
            case 1: {
                list.add("Tart and blue");
                list.add("Found in temperate areas");
                break;
            }
            case 2: {
                list.add("Sweet and black");
                list.add("Found in wet areas");
                break;
            }
            case 3: {
                list.add("Tasty and yellow-orange");
                list.add("Found in cold areas");
            }
        }
    }
}

