/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.Natura;
import mods.natura.common.NaturaTab;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class NetherFoodItem
extends ItemFood {
    public Icon[] icons;
    public String[] textureNames = new String[]{"potashapple"};

    public NetherFoodItem(int id) {
        super(id, 4, 0.4f, false);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(NaturaTab.tab);
    }

    protected void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            int duration = 0;
            switch (stack.getItemDamage()) {
                case 0: {
                    if (!(Natura.random.nextFloat() < 0.75f)) break;
                    PotionEffect potion = player.getActivePotionEffect(Potion.poison);
                    duration = potion != null ? potion.duration : 0;
                    player.addPotionEffect(new PotionEffect(Potion.poison.id, duration + 50, 0));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:fruit_" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Tastes a bit like chalk");
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "item.food.nether." + this.textureNames[itemstack.getItemDamage()];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 1; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }
}

