/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.entity;

import mods.natura.common.NContent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;

public class ImpEntity
extends EntityAnimal {
    public ImpEntity(World par1World) {
        super(par1World);
        this.setSize(0.9f, 0.9f);
        this.getNavigator().setAvoidsWater(true);
        this.isImmuneToFire = true;
        float f = 0.25f;
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.38f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)0.3f, NContent.bowlStew.itemID, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, (double)f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.25, (double)0.3f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, (double)0.28f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(40.0);
    }

    protected void updateAITasks() {
        super.updateAITasks();
    }

    protected String getLivingSound() {
        return "mob.pig.say";
    }

    protected String getHurtSound() {
        return "mob.pig.say";
    }

    protected String getDeathSound() {
        return "mob.pig.death";
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.playSound("mob.pig.step", 0.15f, 1.0f);
    }

    protected int getDropItemId() {
        return NContent.impMeat.itemID;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int iter;
        int amount = this.rand.nextInt(3) + 1 + this.rand.nextInt(1 + par2);
        for (iter = 0; iter < amount; ++iter) {
            this.dropItem(NContent.impMeat.itemID, 1);
        }
        amount = this.rand.nextInt(5) + 2 + this.rand.nextInt(1 + par2 * 2);
        for (iter = 0; iter < amount; ++iter) {
            this.entityDropItem(new ItemStack(NContent.plantItem.itemID, 1, 6), 0.0f);
        }
    }

    public ImpEntity spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        return new ImpEntity(this.worldObj);
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.itemID == NContent.bowlStew.itemID && par1ItemStack.getItemDamage() >= 13;
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.provider instanceof WorldProviderHell && this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox);
    }
}

