/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.RareTreeGen;
import mods.natura.worldgen.WillowGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class OverworldSapling
extends BlockSapling {
    public Icon[] icons;
    public String[] textureNames = new String[]{"maple", "silverbell", "purpleheart", "tiger", "willow"};

    public OverworldSapling(int id) {
        super(id);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setHardness(0.0f);
        this.setStepSound(Block.soundGrassFootstep);
        this.setCreativeTab(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int blockID = world.getBlockId(x, y, z);
        return blockID == 0 || OverworldSapling.blocksList[blockID].blockMaterial.isReplaceable();
    }

    public boolean canThisPlantGrowOnThisBlockID(int id) {
        return id == Block.grass.blockID || id == Block.dirt.blockID || id == Block.slowSand.blockID || id == Block.netherrack.blockID || id == NContent.taintedSoil.blockID;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int blockID = world.getBlockId(x, y - 1, z);
                Block soil = blocksList[blockID];
                return (world.getFullBlockLightValue(x, y, z) >= 8 || world.canBlockSeeTheSky(x, y, z)) && soil != null && soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.isRemote) {
            return;
        }
        super.updateTick(world, x, y, z, random);
        int md = world.getBlockMetadata(x, y, z);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
            if ((md & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, md | 8, 4);
            } else {
                this.growTree(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        return this.icons[meta % 8];
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random random) {
        this.boneFertilize(world, x, y, z, random);
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 8, 4);
        } else {
            this.growTree(world, x, y, z, random);
        }
        return true;
    }

    public void growTree(World world, int x, int y, int z, Random random) {
        int md = world.getBlockMetadata(x, y, z) % 8;
        world.setBlock(x, y, z, 0);
        WorldGenerator obj = null;
        obj = md == 1 ? new RareTreeGen(true, 4, 2, 1, 1) : (md == 2 ? new RareTreeGen(true, 9, 8, 2, 2) : (md == 3 ? new RareTreeGen(true, 6, 4, 3, 3) : (md == 4 ? new WillowGen(true) : new RareTreeGen(true, 4, 2, 0, 0))));
        if (!obj.generate(world, random, x, y, z)) {
            world.setBlock(x, y, z, this.blockID, md + 8, 3);
        }
    }

    public int damageDropped(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.icons.length; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }
}

