/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class SaguaroGen
extends WorldGenerator {
    boolean useHeight;

    public SaguaroGen(int blockID, int metadata, boolean notify) {
        super(true);
        this.useHeight = notify;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean generate(World world, Random random, int x, int y, int z) {
        int yPos = this.findGround(world, x, y, z, this.useHeight);
        int currentID = world.getBlockId(x, yPos, z);
        if (currentID != 0) {
            if (currentID != NContent.saguaro.blockID) return false;
            Block block = Block.blocksList[world.getBlockId(x, yPos - 1, z)];
            if (block == null || !block.canSustainPlant(world, x, yPos - 1, z, ForgeDirection.UP, (IPlantable)NContent.saguaro)) {
                return false;
            }
        } else {
            Block block = Block.blocksList[world.getBlockId(x, yPos - 1, z)];
            if (block == null || !block.canSustainPlant(world, x, yPos - 1, z, ForgeDirection.UP, (IPlantable)NContent.saguaro)) {
                return false;
            }
        }
        if (random.nextInt(20) == 0) {
            this.generateCactusTree(world, random, x, yPos, z);
            return true;
        } else {
            this.generateSmallCactus(world, random, x, yPos, z);
        }
        return true;
    }

    void generateCactusTree(World world, Random random, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.genBlock(world, x, y + i, z);
        }
        this.genBlock(world, x + 1, y + 2, z);
        this.genBlock(world, x - 1, y + 2, z);
        this.genBlock(world, x, y + 2, z + 1);
        this.genBlock(world, x, y + 2, z - 1);
        for (int height = 0; height < 2; ++height) {
            this.genBlock(world, x + 2, y + height + 2, z);
            this.genBlock(world, x - 2, y + height + 2, z);
            this.genBlock(world, x, y + height + 2, z + 2);
            this.genBlock(world, x, y + height + 2, z - 2);
            this.genBlock(world, x + 3, y + height + 3, z);
            this.genBlock(world, x - 3, y + height + 3, z);
            this.genBlock(world, x, y + height + 3, z + 3);
            this.genBlock(world, x, y + height + 3, z - 3);
            this.genBlock(world, x + 1, y + height + 5, z);
            this.genBlock(world, x - 1, y + height + 5, z);
            this.genBlock(world, x, y + height + 5, z + 1);
            this.genBlock(world, x, y + height + 5, z - 1);
        }
    }

    void generateSmallCactus(World world, Random random, int x, int y, int z) {
        int branch;
        int size;
        int height = random.nextInt(4) + 3;
        for (int iter = 0; iter < height; ++iter) {
            this.genBlock(world, x, y + iter, z);
        }
        int branchY = height >= 5 ? 2 : 1;
        y += branchY;
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x + 1, y + branch, z);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x - 1, y + branch, z);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x, y + branch, z + 1);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x, y + branch, z - 1);
            }
        }
    }

    void genBlock(World world, int x, int y, int z) {
        if (!Block.opaqueCubeLookup[world.getBlockId(x, y, z)]) {
            world.setBlock(x, y, z, NContent.saguaro.blockID);
        }
    }

    int findGround(World world, int x, int y, int z, boolean useHeight) {
        if (useHeight) {
            return y;
        }
        boolean foundGround = false;
        int height = PHNatura.seaLevel + 64;
        do {
            int underID;
            if ((underID = world.getBlockId(x, --height, z)) != Block.dirt.blockID && underID != Block.grass.blockID && height >= PHNatura.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }
}

