/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManagerINNER1;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.renderer.texture.TickableTextureObject;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.ResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements Tickable,
ResourceManagerReloadListener {
    private final Map field_110585_a = Maps.newHashMap();
    private final Map field_130089_b = Maps.newHashMap();
    private final List field_110583_b = Lists.newArrayList();
    private final Map field_110584_c = Maps.newHashMap();
    private ResourceManager field_110582_d;

    public TextureManager(ResourceManager p_i1284_1_) {
        this.field_110582_d = p_i1284_1_;
    }

    public void func_110577_a(ResourceLocation p_110577_1_) {
        TextureObject textureObject = (TextureObject)this.field_110585_a.get(p_110577_1_);
        if (textureObject == null) {
            textureObject = new SimpleTexture(p_110577_1_);
            this.func_110579_a(p_110577_1_, textureObject);
        }
        TextureUtil.func_94277_a(textureObject.func_110552_b());
    }

    public ResourceLocation func_130087_a(int p_130087_1_) {
        return (ResourceLocation)this.field_130089_b.get(p_130087_1_);
    }

    public boolean func_130088_a(ResourceLocation p_130088_1_, TextureMap p_130088_2_) {
        if (this.func_110580_a(p_130088_1_, p_130088_2_)) {
            this.field_130089_b.put(p_130088_2_.func_130086_a(), p_130088_1_);
            return true;
        }
        return false;
    }

    public boolean func_110580_a(ResourceLocation p_110580_1_, TickableTextureObject p_110580_2_) {
        if (this.func_110579_a(p_110580_1_, p_110580_2_)) {
            this.field_110583_b.add(p_110580_2_);
            return true;
        }
        return false;
    }

    public boolean func_110579_a(ResourceLocation p_110579_1_, TextureObject p_110579_2_) {
        boolean bl = true;
        try {
            p_110579_2_.func_110551_a(this.field_110582_d);
        }
        catch (IOException iOException) {
            Minecraft.func_71410_x().func_98033_al().func_98235_b("Failed to load texture: " + p_110579_1_, iOException);
            p_110579_2_ = TextureUtil.field_111001_a;
            this.field_110585_a.put(p_110579_1_, p_110579_2_);
            bl = false;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Resource location being registered");
            TextureObject textureObject = p_110579_2_;
            crashReportCategory.func_71507_a("Resource location", p_110579_1_);
            crashReportCategory.func_71500_a("Texture object class", new TextureManagerINNER1(this, textureObject));
            throw new ReportedException(crashReport);
        }
        this.field_110585_a.put(p_110579_1_, p_110579_2_);
        return bl;
    }

    public TextureObject func_110581_b(ResourceLocation p_110581_1_) {
        return (TextureObject)this.field_110585_a.get(p_110581_1_);
    }

    public ResourceLocation func_110578_a(String p_110578_1_, DynamicTexture p_110578_2_) {
        Object object;
        Integer n = (Integer)this.field_110584_c.get(p_110578_1_);
        if (n == null) {
            n = 1;
        } else {
            object = n;
            Integer n2 = n = Integer.valueOf(n + 1);
        }
        this.field_110584_c.put(p_110578_1_, n);
        object = new ResourceLocation(String.format("dynamic/%s_%d", p_110578_1_, n));
        this.func_110579_a((ResourceLocation)object, p_110578_2_);
        return object;
    }

    @Override
    public void func_110550_d() {
        for (Tickable tickable : this.field_110583_b) {
            tickable.func_110550_d();
        }
    }

    @Override
    public void func_110549_a(ResourceManager p_110549_1_) {
        for (Map.Entry entry : this.field_110585_a.entrySet()) {
            this.func_110579_a((ResourceLocation)entry.getKey(), (TextureObject)entry.getValue());
        }
    }
}

