/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.audio.ScheduledSound;
import net.minecraft.client.audio.SoundManagerINNER1;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.ResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import org.apache.commons.io.FileUtils;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

@SideOnly(value=Side.CLIENT)
public class SoundManager
implements ResourceManagerReloadListener {
    private static final String[] field_130084_a = new String[]{"ogg"};
    public SoundSystem field_77381_a;
    private boolean field_77376_g;
    public final SoundPool field_77379_b;
    public final SoundPool field_77380_c;
    public final SoundPool field_77377_d;
    private int field_77378_e;
    private final GameSettings field_77375_f;
    private final File field_130085_i;
    private final Set field_82470_g = new HashSet();
    private final List field_92072_h = new ArrayList();
    private Random field_77382_h = new Random();
    private int field_77383_i = this.field_77382_h.nextInt(12000);

    public SoundManager(ResourceManager p_i1326_1_, GameSettings p_i1326_2_, File p_i1326_3_) {
        this.field_77375_f = p_i1326_2_;
        this.field_130085_i = p_i1326_3_;
        this.field_77379_b = new SoundPool(p_i1326_1_, "sound", true);
        this.field_77380_c = new SoundPool(p_i1326_1_, "records", false);
        this.field_77377_d = new SoundPool(p_i1326_1_, "music", true);
        try {
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
        }
        catch (SoundSystemException soundSystemException) {
            soundSystemException.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        this.func_130083_h();
    }

    @Override
    public void func_110549_a(ResourceManager p_110549_1_) {
        this.func_82464_d();
        this.func_77370_b();
        this.func_77363_d();
    }

    private void func_130083_h() {
        if (this.field_130085_i.isDirectory()) {
            Collection collection = FileUtils.listFiles((File)this.field_130085_i, (String[])field_130084_a, (boolean)true);
            for (File file : collection) {
                this.func_130081_a(file);
            }
        }
    }

    private void func_130081_a(File p_130081_1_) {
        String string = this.field_130085_i.toURI().relativize(p_130081_1_.toURI()).getPath();
        int n = string.indexOf("/");
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        if ("sound".equalsIgnoreCase(string2)) {
            this.func_77372_a(string);
        } else if ("records".equalsIgnoreCase(string2)) {
            this.func_77374_b(string);
        } else if ("music".equalsIgnoreCase(string2)) {
            this.func_77365_c(string);
        }
    }

    private synchronized void func_77363_d() {
        if (this.field_77376_g) {
            return;
        }
        float f = this.field_77375_f.field_74340_b;
        float f2 = this.field_77375_f.field_74342_a;
        this.field_77375_f.field_74340_b = 0.0f;
        this.field_77375_f.field_74342_a = 0.0f;
        this.field_77375_f.func_74303_b();
        try {
            new Thread(new SoundManagerINNER1(this)).start();
            this.field_77375_f.field_74340_b = f;
            this.field_77375_f.field_74342_a = f2;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.err.println("error starting SoundSystem turning off sounds & music");
            this.field_77375_f.field_74340_b = 0.0f;
            this.field_77375_f.field_74342_a = 0.0f;
        }
        this.field_77375_f.func_74303_b();
    }

    public void func_77367_a() {
        if (!this.field_77376_g) {
            return;
        }
        if (this.field_77375_f.field_74342_a == 0.0f) {
            this.field_77381_a.stop("BgMusic");
            this.field_77381_a.stop("streaming");
        } else {
            this.field_77381_a.setVolume("BgMusic", this.field_77375_f.field_74342_a);
            this.field_77381_a.setVolume("streaming", this.field_77375_f.field_74342_a);
        }
    }

    public void func_77370_b() {
        if (this.field_77376_g) {
            this.field_77381_a.cleanup();
            this.field_77376_g = false;
        }
    }

    public void func_77372_a(String p_77372_1_) {
        this.field_77379_b.func_77459_a(p_77372_1_);
    }

    public void func_77374_b(String p_77374_1_) {
        this.field_77380_c.func_77459_a(p_77374_1_);
    }

    public void func_77365_c(String p_77365_1_) {
        this.field_77377_d.func_77459_a(p_77365_1_);
    }

    public void func_77371_c() {
        if (!this.field_77376_g || this.field_77375_f.field_74342_a == 0.0f) {
            return;
        }
        if (this.field_77381_a.playing("BgMusic") || this.field_77381_a.playing("streaming")) {
            return;
        }
        if (this.field_77383_i > 0) {
            --this.field_77383_i;
            return;
        }
        SoundPoolEntry soundPoolEntry = this.field_77377_d.func_77460_a();
        if (soundPoolEntry != null) {
            this.field_77383_i = this.field_77382_h.nextInt(12000) + 12000;
            this.field_77381_a.backgroundMusic("BgMusic", soundPoolEntry.func_110457_b(), soundPoolEntry.func_110458_a(), false);
            this.field_77381_a.setVolume("BgMusic", this.field_77375_f.field_74342_a);
            this.field_77381_a.play("BgMusic");
        }
    }

    public void func_77369_a(EntityLivingBase p_77369_1_, float p_77369_2_) {
        if (!this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f || p_77369_1_ == null) {
            return;
        }
        float f = p_77369_1_.field_70127_C + (p_77369_1_.field_70125_A - p_77369_1_.field_70127_C) * p_77369_2_;
        float f2 = p_77369_1_.field_70126_B + (p_77369_1_.field_70177_z - p_77369_1_.field_70126_B) * p_77369_2_;
        double d = p_77369_1_.field_70169_q + (p_77369_1_.field_70165_t - p_77369_1_.field_70169_q) * (double)p_77369_2_;
        double d2 = p_77369_1_.field_70167_r + (p_77369_1_.field_70163_u - p_77369_1_.field_70167_r) * (double)p_77369_2_;
        double d3 = p_77369_1_.field_70166_s + (p_77369_1_.field_70161_v - p_77369_1_.field_70166_s) * (double)p_77369_2_;
        float f3 = MathHelper.func_76134_b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = MathHelper.func_76126_a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f5 = -f4;
        float f6 = -MathHelper.func_76126_a(-f * ((float)Math.PI / 180) - (float)Math.PI);
        float f7 = -f3;
        float f8 = 0.0f;
        float f9 = 1.0f;
        float f10 = 0.0f;
        this.field_77381_a.setListenerPosition((float)d, (float)d2, (float)d3);
        this.field_77381_a.setListenerOrientation(f5, f6, f7, f8, f9, f10);
    }

    public void func_82464_d() {
        if (this.field_77376_g) {
            for (String string : this.field_82470_g) {
                this.field_77381_a.stop(string);
            }
            this.field_82470_g.clear();
        }
    }

    public void func_77368_a(String p_77368_1_, float p_77368_2_, float p_77368_3_, float p_77368_4_) {
        if (!this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f && p_77368_1_ != null) {
            return;
        }
        String string = "streaming";
        if (this.field_77381_a.playing(string)) {
            this.field_77381_a.stop(string);
        }
        if (p_77368_1_ == null) {
            return;
        }
        SoundPoolEntry soundPoolEntry = this.field_77380_c.func_77458_a(p_77368_1_);
        if (soundPoolEntry != null) {
            if (this.field_77381_a.playing("BgMusic")) {
                this.field_77381_a.stop("BgMusic");
            }
            this.field_77381_a.newStreamingSource(true, string, soundPoolEntry.func_110457_b(), soundPoolEntry.func_110458_a(), false, p_77368_2_, p_77368_3_, p_77368_4_, 2, 64.0f);
            this.field_77381_a.setVolume(string, 0.5f * this.field_77375_f.field_74340_b);
            this.field_77381_a.play(string);
        }
    }

    public void func_82460_a(Entity p_82460_1_) {
        this.func_82462_a(p_82460_1_, p_82460_1_);
    }

    public void func_82462_a(Entity p_82462_1_, Entity p_82462_2_) {
        String string = "entity_" + p_82462_1_.field_70157_k;
        if (this.field_82470_g.contains(string)) {
            if (this.field_77381_a.playing(string)) {
                this.field_77381_a.setPosition(string, (float)p_82462_2_.field_70165_t, (float)p_82462_2_.field_70163_u, (float)p_82462_2_.field_70161_v);
                this.field_77381_a.setVelocity(string, (float)p_82462_2_.field_70159_w, (float)p_82462_2_.field_70181_x, (float)p_82462_2_.field_70179_y);
            } else {
                this.field_82470_g.remove(string);
            }
        }
    }

    public boolean func_82465_b(Entity p_82465_1_) {
        if (p_82465_1_ == null || !this.field_77376_g) {
            return false;
        }
        String string = "entity_" + p_82465_1_.field_70157_k;
        return this.field_77381_a.playing(string);
    }

    public void func_82469_c(Entity p_82469_1_) {
        if (p_82469_1_ == null || !this.field_77376_g) {
            return;
        }
        String string = "entity_" + p_82469_1_.field_70157_k;
        if (this.field_82470_g.contains(string)) {
            if (this.field_77381_a.playing(string)) {
                this.field_77381_a.stop(string);
            }
            this.field_82470_g.remove(string);
        }
    }

    public void func_82468_a(Entity p_82468_1_, float p_82468_2_) {
        if (p_82468_1_ == null || !this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f) {
            return;
        }
        String string = "entity_" + p_82468_1_.field_70157_k;
        if (!this.field_77381_a.playing(string)) {
            return;
        }
        this.field_77381_a.setVolume(string, p_82468_2_ * this.field_77375_f.field_74340_b);
    }

    public void func_82463_b(Entity p_82463_1_, float p_82463_2_) {
        if (p_82463_1_ == null || !this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f) {
            return;
        }
        String string = "entity_" + p_82463_1_.field_70157_k;
        if (!this.field_77381_a.playing(string)) {
            return;
        }
        this.field_77381_a.setPitch(string, p_82463_2_);
    }

    public void func_82467_a(String p_82467_1_, Entity p_82467_2_, float p_82467_3_, float p_82467_4_, boolean p_82467_5_) {
        if (!this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f && p_82467_1_ != null || p_82467_2_ == null) {
            return;
        }
        String string = "entity_" + p_82467_2_.field_70157_k;
        if (this.field_82470_g.contains(string)) {
            this.func_82460_a(p_82467_2_);
            return;
        }
        if (this.field_77381_a.playing(string)) {
            this.field_77381_a.stop(string);
        }
        if (p_82467_1_ == null) {
            return;
        }
        SoundPoolEntry soundPoolEntry = this.field_77379_b.func_77458_a(p_82467_1_);
        if (soundPoolEntry != null && p_82467_3_ > 0.0f) {
            float f = 16.0f;
            if (p_82467_3_ > 1.0f) {
                f *= p_82467_3_;
            }
            this.field_77381_a.newSource(p_82467_5_, string, soundPoolEntry.func_110457_b(), soundPoolEntry.func_110458_a(), false, (float)p_82467_2_.field_70165_t, (float)p_82467_2_.field_70163_u, (float)p_82467_2_.field_70161_v, 2, f);
            this.field_77381_a.setLooping(string, true);
            this.field_77381_a.setPitch(string, p_82467_4_);
            if (p_82467_3_ > 1.0f) {
                p_82467_3_ = 1.0f;
            }
            this.field_77381_a.setVolume(string, p_82467_3_ * this.field_77375_f.field_74340_b);
            this.field_77381_a.setVelocity(string, (float)p_82467_2_.field_70159_w, (float)p_82467_2_.field_70181_x, (float)p_82467_2_.field_70179_y);
            this.field_77381_a.play(string);
            this.field_82470_g.add(string);
        }
    }

    public void func_77364_b(String p_77364_1_, float p_77364_2_, float p_77364_3_, float p_77364_4_, float p_77364_5_, float p_77364_6_) {
        if (!this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f) {
            return;
        }
        SoundPoolEntry soundPoolEntry = this.field_77379_b.func_77458_a(p_77364_1_);
        if (soundPoolEntry != null && p_77364_5_ > 0.0f) {
            this.field_77378_e = (this.field_77378_e + 1) % 256;
            String string = "sound_" + this.field_77378_e;
            float f = 16.0f;
            if (p_77364_5_ > 1.0f) {
                f *= p_77364_5_;
            }
            this.field_77381_a.newSource(p_77364_5_ > 1.0f, string, soundPoolEntry.func_110457_b(), soundPoolEntry.func_110458_a(), false, p_77364_2_, p_77364_3_, p_77364_4_, 2, f);
            if (p_77364_5_ > 1.0f) {
                p_77364_5_ = 1.0f;
            }
            this.field_77381_a.setPitch(string, p_77364_6_);
            this.field_77381_a.setVolume(string, p_77364_5_ * this.field_77375_f.field_74340_b);
            this.field_77381_a.play(string);
        }
    }

    public void func_77366_a(String p_77366_1_, float p_77366_2_, float p_77366_3_) {
        if (!this.field_77376_g || this.field_77375_f.field_74340_b == 0.0f) {
            return;
        }
        SoundPoolEntry soundPoolEntry = this.field_77379_b.func_77458_a(p_77366_1_);
        if (soundPoolEntry != null && p_77366_2_ > 0.0f) {
            this.field_77378_e = (this.field_77378_e + 1) % 256;
            String string = "sound_" + this.field_77378_e;
            this.field_77381_a.newSource(false, string, soundPoolEntry.func_110457_b(), soundPoolEntry.func_110458_a(), false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (p_77366_2_ > 1.0f) {
                p_77366_2_ = 1.0f;
            }
            this.field_77381_a.setPitch(string, p_77366_3_);
            this.field_77381_a.setVolume(string, (p_77366_2_ *= 0.25f) * this.field_77375_f.field_74340_b);
            this.field_77381_a.play(string);
        }
    }

    public void func_82466_e() {
        for (String string : this.field_82470_g) {
            this.field_77381_a.pause(string);
        }
    }

    public void func_82461_f() {
        for (String string : this.field_82470_g) {
            this.field_77381_a.play(string);
        }
    }

    public void func_92071_g() {
        if (this.field_92072_h.isEmpty()) {
            return;
        }
        Iterator iterator = this.field_92072_h.iterator();
        while (iterator.hasNext()) {
            ScheduledSound scheduledSound = (ScheduledSound)iterator.next();
            --scheduledSound.field_92064_g;
            if (scheduledSound.field_92064_g > 0) continue;
            this.func_77364_b(scheduledSound.field_92069_a, scheduledSound.field_92067_b, scheduledSound.field_92068_c, scheduledSound.field_92065_d, scheduledSound.field_92066_e, scheduledSound.field_92063_f);
            iterator.remove();
        }
    }

    public void func_92070_a(String p_92070_1_, float p_92070_2_, float p_92070_3_, float p_92070_4_, float p_92070_5_, float p_92070_6_, int p_92070_7_) {
        this.field_92072_h.add(new ScheduledSound(p_92070_1_, p_92070_2_, p_92070_3_, p_92070_4_, p_92070_5_, p_92070_6_, p_92070_7_));
    }

    static /* synthetic */ SoundSystem func_130080_a(SoundManager p_130080_0_, SoundSystem p_130080_1_) {
        p_130080_0_.field_77381_a = p_130080_1_;
        return p_130080_0_.field_77381_a;
    }

    static /* synthetic */ boolean func_130082_a(SoundManager p_130082_0_, boolean p_130082_1_) {
        p_130082_0_.field_77376_g = p_130082_1_;
        return p_130082_0_.field_77376_g;
    }
}

