/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.dispenser.DispenserBehaviors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.logging.ILogAgent;
import net.minecraft.network.NetworkListenThread;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet4UpdateTime;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.CallableIsServerModded;
import net.minecraft.server.CallableServerMemoryStats;
import net.minecraft.server.CallableServerProfiler;
import net.minecraft.server.ConvertingProgressUpdate;
import net.minecraft.server.ThreadDedicatedServer;
import net.minecraft.server.ThreadMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldManager;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public abstract class MinecraftServer
implements ICommandSender,
Runnable,
IPlayerUsage {
    private static MinecraftServer field_71309_l;
    private final ISaveFormat field_71310_m;
    private final PlayerUsageSnooper field_71307_n = new PlayerUsageSnooper("server", this, MinecraftServer.func_130071_aq());
    private final File field_71308_o;
    private final List field_71322_p = new ArrayList();
    private final ICommandManager field_71321_q;
    public final Profiler field_71304_b = new Profiler();
    private String field_71320_r;
    private int field_71319_s = -1;
    public WorldServer[] field_71305_c;
    private ServerConfigurationManager field_71318_t;
    private boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected Proxy field_110456_c = Proxy.NO_PROXY;
    public String field_71302_d;
    public int field_71303_e;
    private boolean field_71325_x;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E = 0;
    private long field_71281_E;
    private long field_71282_F;
    private long field_71283_G;
    private long field_71291_H;
    public final long[] field_71300_f = new long[100];
    public final long[] field_71301_g = new long[100];
    public final long[] field_71313_h = new long[100];
    public final long[] field_71314_i = new long[100];
    public final long[] field_71311_j = new long[100];
    public long[][] field_71312_k;
    private KeyPair field_71292_I;
    private String field_71293_J;
    private String field_71294_K;
    @SideOnly(value=Side.CLIENT)
    private String field_71287_L;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private boolean field_71290_O;
    private String field_71297_P = "";
    private boolean field_71296_Q;
    private long field_71299_R;
    private String field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;

    public MinecraftServer(File p_i1498_1_) {
        field_71309_l = this;
        this.field_71308_o = p_i1498_1_;
        this.field_71321_q = new ServerCommandManager();
        this.field_71310_m = new AnvilSaveConverter(p_i1498_1_);
        this.func_82355_al();
    }

    private void func_82355_al() {
        DispenserBehaviors.func_96467_a();
    }

    protected abstract boolean func_71197_b() throws IOException;

    protected void func_71237_c(String p_71237_1_) {
        if (this.func_71254_M().func_75801_b(p_71237_1_)) {
            this.func_98033_al().func_98233_a("Converting map!");
            this.func_71192_d("menu.convertingLevel");
            this.func_71254_M().func_75805_a(p_71237_1_, new ConvertingProgressUpdate(this));
        }
    }

    protected synchronized void func_71192_d(String p_71192_1_) {
        this.field_71298_S = p_71192_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized String func_71195_b_() {
        return this.field_71298_S;
    }

    protected void func_71247_a(String p_71247_1_, String p_71247_2_, long p_71247_3_, WorldType p_71247_5_, String p_71247_6_) {
        WorldSettings worldSettings;
        this.func_71237_c(p_71247_1_);
        this.func_71192_d("menu.loadingLevel");
        this.field_71305_c = new WorldServer[3];
        this.field_71312_k = new long[this.field_71305_c.length][100];
        ISaveHandler iSaveHandler = this.field_71310_m.func_75804_a(p_71247_1_, true);
        WorldInfo worldInfo = iSaveHandler.func_75757_d();
        if (worldInfo == null) {
            worldSettings = new WorldSettings(p_71247_3_, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), p_71247_5_);
            worldSettings.func_82750_a(p_71247_6_);
        } else {
            worldSettings = new WorldSettings(worldInfo);
        }
        if (this.field_71289_N) {
            worldSettings.func_77159_a();
        }
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            int n = 0;
            if (i == 1) {
                n = -1;
            }
            if (i == 2) {
                n = 1;
            }
            this.field_71305_c[i] = i == 0 ? (this.func_71242_L() ? new DemoWorldServer(this, iSaveHandler, p_71247_2_, n, this.field_71304_b, this.func_98033_al()) : new WorldServer(this, iSaveHandler, p_71247_2_, n, worldSettings, this.field_71304_b, this.func_98033_al())) : new WorldServerMulti(this, iSaveHandler, p_71247_2_, n, worldSettings, this.field_71305_c[0], this.field_71304_b, this.func_98033_al());
            this.field_71305_c[i].func_72954_a(new WorldManager(this, this.field_71305_c[i]));
            if (!this.func_71264_H()) {
                this.field_71305_c[i].func_72912_H().func_76060_a(this.func_71265_f());
            }
            this.field_71318_t.func_72364_a(this.field_71305_c);
        }
        this.func_71226_c(this.func_71232_g());
        this.func_71222_d();
    }

    protected void func_71222_d() {
        int n = 16;
        int n2 = 4;
        int n3 = 192;
        int n4 = 625;
        int n5 = 0;
        this.func_71192_d("menu.generatingTerrain");
        int n6 = 0;
        this.func_98033_al().func_98233_a("Preparing start region for level " + n6);
        WorldServer worldServer = this.field_71305_c[n6];
        ChunkCoordinates chunkCoordinates = worldServer.func_72861_E();
        long l = MinecraftServer.func_130071_aq();
        for (int i = -192; i <= 192 && this.func_71278_l(); i += 16) {
            for (int j = -192; j <= 192 && this.func_71278_l(); j += 16) {
                long l2 = MinecraftServer.func_130071_aq();
                if (l2 - l > 1000L) {
                    this.func_71216_a_("Preparing spawn area", n5 * 100 / 625);
                    l = l2;
                }
                ++n5;
                worldServer.field_73059_b.func_73158_c(chunkCoordinates.field_71574_a + i >> 4, chunkCoordinates.field_71573_c + j >> 4);
            }
        }
        this.func_71243_i();
    }

    public abstract boolean func_71225_e();

    public abstract EnumGameType func_71265_f();

    public abstract int func_71232_g();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    protected void func_71216_a_(String p_71216_1_, int p_71216_2_) {
        this.field_71302_d = p_71216_1_;
        this.field_71303_e = p_71216_2_;
        this.func_98033_al().func_98233_a(p_71216_1_ + ": " + p_71216_2_ + "%");
    }

    protected void func_71243_i() {
        this.field_71302_d = null;
        this.field_71303_e = 0;
    }

    protected void func_71267_a(boolean p_71267_1_) {
        if (this.field_71290_O) {
            return;
        }
        for (WorldServer worldServer : this.field_71305_c) {
            if (worldServer == null) continue;
            if (!p_71267_1_) {
                this.func_98033_al().func_98233_a("Saving chunks for level '" + worldServer.func_72912_H().func_76065_j() + "'/" + worldServer.field_73011_w.func_80007_l());
            }
            try {
                worldServer.func_73044_a(true, null);
            }
            catch (MinecraftException minecraftException) {
                this.func_98033_al().func_98236_b(minecraftException.getMessage());
            }
        }
    }

    public void func_71260_j() {
        if (this.field_71290_O) {
            return;
        }
        this.func_98033_al().func_98233_a("Stopping server");
        if (this.func_71212_ac() != null) {
            this.func_71212_ac().func_71744_a();
        }
        if (this.field_71318_t != null) {
            this.func_98033_al().func_98233_a("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        this.func_98033_al().func_98233_a("Saving worlds");
        this.func_71267_a(false);
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            WorldServer worldServer = this.field_71305_c[i];
            worldServer.func_73041_k();
        }
        if (this.field_71307_n != null && this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String p_71189_1_) {
        this.field_71320_r = p_71189_1_;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m() {
        this.field_71317_u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.func_71197_b()) {
                long l = MinecraftServer.func_130071_aq();
                long l2 = 0L;
                while (this.field_71317_u) {
                    long l3 = MinecraftServer.func_130071_aq();
                    long l4 = l3 - l;
                    if (l4 > 2000L && l - this.field_71299_R >= 15000L) {
                        this.func_98033_al().func_98236_b("Can't keep up! Did the system time change, or is the server overloaded?");
                        l4 = 2000L;
                        this.field_71299_R = l;
                    }
                    if (l4 < 0L) {
                        this.func_98033_al().func_98236_b("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    l = l3;
                    if (this.field_71305_c[0].func_73056_e()) {
                        this.func_71217_p();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.func_71217_p();
                        }
                    }
                    Thread.sleep(1L);
                    this.field_71296_Q = true;
                }
            } else {
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.func_98033_al().func_98234_c("Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            CrashReport crashReport = null;
            crashReport = throwable instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable));
            File file = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.func_71508_a(file, this.func_98033_al())) {
                this.func_98033_al().func_98232_c("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                this.func_98033_al().func_98232_c("We were unable to save this crash report to disk.");
            }
            this.func_71228_a(crashReport);
        }
        finally {
            try {
                this.func_71260_j();
                this.field_71316_v = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.func_71240_o();
            }
        }
    }

    protected File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport p_71228_1_) {
    }

    protected void func_71240_o() {
    }

    public void func_71217_p() {
        long l = System.nanoTime();
        AxisAlignedBB.func_72332_a().func_72298_a();
        ++this.field_71315_w;
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_71304_b.field_76327_a = true;
            this.field_71304_b.func_76317_a();
        }
        this.field_71304_b.func_76320_a("root");
        this.func_71190_q();
        if (this.field_71315_w % 900 == 0) {
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_71267_a(true);
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_76320_a("tallying");
        this.field_71311_j[this.field_71315_w % 100] = System.nanoTime() - l;
        this.field_71300_f[this.field_71315_w % 100] = Packet.field_73290_p - this.field_71281_E;
        this.field_71281_E = Packet.field_73290_p;
        this.field_71301_g[this.field_71315_w % 100] = Packet.field_73289_q - this.field_71282_F;
        this.field_71282_F = Packet.field_73289_q;
        this.field_71313_h[this.field_71315_w % 100] = Packet.field_73292_n - this.field_71283_G;
        this.field_71283_G = Packet.field_73292_n;
        this.field_71314_i[this.field_71315_w % 100] = Packet.field_73293_o - this.field_71291_H;
        this.field_71291_H = Packet.field_73293_o;
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76319_b();
    }

    public void func_71190_q() {
        int n;
        this.field_71304_b.func_76320_a("levels");
        for (n = 0; n < this.field_71305_c.length; ++n) {
            long l = System.nanoTime();
            if (n == 0 || this.func_71255_r()) {
                WorldServer worldServer = this.field_71305_c[n];
                this.field_71304_b.func_76320_a(worldServer.func_72912_H().func_76065_j());
                this.field_71304_b.func_76320_a("pools");
                worldServer.func_82732_R().func_72343_a();
                this.field_71304_b.func_76319_b();
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_72396_a(new Packet4UpdateTime(worldServer.func_82737_E(), worldServer.func_72820_D(), worldServer.func_82736_K().func_82766_b("doDaylightCycle")), worldServer.field_73011_w.field_76574_g);
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                try {
                    worldServer.func_72835_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                    worldServer.func_72914_a(crashReport);
                    throw new ReportedException(crashReport);
                }
                try {
                    worldServer.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world entities");
                    worldServer.func_72914_a(crashReport);
                    throw new ReportedException(crashReport);
                }
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                worldServer.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.field_71312_k[n][this.field_71315_w % 100] = System.nanoTime() - l;
        }
        this.field_71304_b.func_76318_c("connection");
        this.func_71212_ac().func_71747_b();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (n = 0; n < this.field_71322_p.size(); ++n) {
            ((IUpdatePlayerListBox)this.field_71322_p.get(n)).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_71256_s() {
        new ThreadMinecraftServer(this, "Server thread").start();
    }

    public File func_71209_f(String p_71209_1_) {
        return new File(this.func_71238_n(), p_71209_1_);
    }

    public void func_71244_g(String p_71244_1_) {
        this.func_98033_al().func_98233_a(p_71244_1_);
    }

    public void func_71236_h(String p_71236_1_) {
        this.func_98033_al().func_98236_b(p_71236_1_);
    }

    public WorldServer func_71218_a(int p_71218_1_) {
        if (p_71218_1_ == -1) {
            return this.field_71305_c[1];
        }
        if (p_71218_1_ == 1) {
            return this.field_71305_c[2];
        }
        return this.field_71305_c[0];
    }

    @SideOnly(value=Side.SERVER)
    public void func_82010_a(IUpdatePlayerListBox p_82010_1_) {
        this.field_71322_p.add(p_82010_1_);
    }

    public String func_71277_t() {
        return this.field_71320_r;
    }

    public int func_71234_u() {
        return this.field_71319_s;
    }

    public String func_71274_v() {
        return this.field_71286_C;
    }

    public String func_71249_w() {
        return "1.6.4";
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public String func_71258_A() {
        return "";
    }

    public String func_71252_i(String p_71252_1_) {
        RConConsoleSource.field_70010_a.func_70007_b();
        this.field_71321_q.func_71556_a(RConConsoleSource.field_70010_a, p_71252_1_);
        return RConConsoleSource.field_70010_a.func_70008_c();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String p_71201_1_) {
        this.func_98033_al().func_98232_c(p_71201_1_);
    }

    public void func_71198_k(String p_71198_1_) {
        if (this.func_71239_B()) {
            this.func_98033_al().func_98233_a(p_71198_1_);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport func_71230_b(CrashReport p_71230_1_) {
        p_71230_1_.func_85056_g().func_71500_a("Profiler Position", new CallableIsServerModded(this));
        if (this.field_71305_c != null && this.field_71305_c.length > 0 && this.field_71305_c[0] != null) {
            p_71230_1_.func_85056_g().func_71500_a("Vec3 Pool Size", new CallableServerProfiler(this));
        }
        if (this.field_71318_t != null) {
            p_71230_1_.func_85056_g().func_71500_a("Player Count", new CallableServerMemoryStats(this));
        }
        return p_71230_1_;
    }

    public List func_71248_a(ICommandSender p_71248_1_, String p_71248_2_) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (p_71248_2_.startsWith("/")) {
            boolean bl = !(p_71248_2_ = p_71248_2_.substring(1)).contains(" ");
            List list = this.field_71321_q.func_71558_b(p_71248_1_, p_71248_2_);
            if (list != null) {
                for (String string : list) {
                    if (bl) {
                        arrayList.add("/" + string);
                        continue;
                    }
                    arrayList.add(string);
                }
            }
            return arrayList;
        }
        String[] stringArray = p_71248_2_.split(" ", -1);
        String string = stringArray[stringArray.length - 1];
        for (String string2 : this.field_71318_t.func_72369_d()) {
            if (!CommandBase.func_71523_a(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static MinecraftServer func_71276_C() {
        return field_71309_l;
    }

    @Override
    public String func_70005_c_() {
        return "Server";
    }

    @Override
    public void func_70006_a(ChatMessageComponent p_70006_1_) {
        this.func_98033_al().func_98233_a(p_70006_1_.toString());
    }

    @Override
    public boolean func_70003_b(int p_70003_1_, String p_70003_2_) {
        return true;
    }

    public ICommandManager func_71187_D() {
        return this.field_71321_q;
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int p_71208_1_) {
        this.field_71319_s = p_71208_1_;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String p_71224_1_) {
        this.field_71293_J = p_71224_1_;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    public void func_71261_m(String p_71261_1_) {
        this.field_71294_K = p_71261_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71246_n(String p_71246_1_) {
        this.field_71287_L = p_71246_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_71221_J() {
        return this.field_71287_L;
    }

    public void func_71253_a(KeyPair p_71253_1_) {
        this.field_71292_I = p_71253_1_;
    }

    public void func_71226_c(int p_71226_1_) {
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            WorldServer worldServer = this.field_71305_c[i];
            if (worldServer == null) continue;
            if (worldServer.func_72912_H().func_76093_s()) {
                worldServer.field_73013_u = 3;
                worldServer.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldServer.field_73013_u = p_71226_1_;
                worldServer.func_72891_a(worldServer.field_73013_u > 0, true);
                continue;
            }
            worldServer.field_73013_u = p_71226_1_;
            worldServer.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
    }

    protected boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean p_71204_1_) {
        this.field_71288_M = p_71204_1_;
    }

    public void func_71194_c(boolean p_71194_1_) {
        this.field_71289_N = p_71194_1_;
    }

    public ISaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public void func_71272_O() {
        this.field_71290_O = true;
        this.func_71254_M().func_75800_d();
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            WorldServer worldServer = this.field_71305_c[i];
            if (worldServer == null) continue;
            worldServer.func_73041_k();
        }
        this.func_71254_M().func_75802_e(this.field_71305_c[0].func_72860_G().func_75760_g());
        this.func_71263_m();
    }

    public String func_71202_P() {
        return this.field_71297_P;
    }

    public void func_71269_o(String p_71269_1_) {
        this.field_71297_P = p_71269_1_;
    }

    @Override
    public void func_70000_a(PlayerUsageSnooper p_70000_1_) {
        p_70000_1_.func_76472_a("whitelist_enabled", false);
        p_70000_1_.func_76472_a("whitelist_count", 0);
        p_70000_1_.func_76472_a("players_current", this.func_71233_x());
        p_70000_1_.func_76472_a("players_max", this.func_71275_y());
        p_70000_1_.func_76472_a("players_seen", this.field_71318_t.func_72373_m().length);
        p_70000_1_.func_76472_a("uses_auth", this.field_71325_x);
        p_70000_1_.func_76472_a("gui_state", this.func_71279_ae() ? "enabled" : "disabled");
        p_70000_1_.func_76472_a("run_time", (MinecraftServer.func_130071_aq() - p_70000_1_.func_130105_g()) / 60L * 1000L);
        p_70000_1_.func_76472_a("avg_tick_ms", (int)(MathHelper.func_76127_a(this.field_71311_j) * 1.0E-6));
        p_70000_1_.func_76472_a("avg_sent_packet_count", (int)MathHelper.func_76127_a(this.field_71300_f));
        p_70000_1_.func_76472_a("avg_sent_packet_size", (int)MathHelper.func_76127_a(this.field_71301_g));
        p_70000_1_.func_76472_a("avg_rec_packet_count", (int)MathHelper.func_76127_a(this.field_71313_h));
        p_70000_1_.func_76472_a("avg_rec_packet_size", (int)MathHelper.func_76127_a(this.field_71314_i));
        int n = 0;
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            if (this.field_71305_c[i] == null) continue;
            WorldServer worldServer = this.field_71305_c[i];
            WorldInfo worldInfo = worldServer.func_72912_H();
            p_70000_1_.func_76472_a("world[" + n + "][dimension]", worldServer.field_73011_w.field_76574_g);
            p_70000_1_.func_76472_a("world[" + n + "][mode]", (Object)worldInfo.func_76077_q());
            p_70000_1_.func_76472_a("world[" + n + "][difficulty]", worldServer.field_73013_u);
            p_70000_1_.func_76472_a("world[" + n + "][hardcore]", worldInfo.func_76093_s());
            p_70000_1_.func_76472_a("world[" + n + "][generator_name]", worldInfo.func_76067_t().func_77127_a());
            p_70000_1_.func_76472_a("world[" + n + "][generator_version]", worldInfo.func_76067_t().func_77131_c());
            p_70000_1_.func_76472_a("world[" + n + "][height]", this.field_71280_D);
            p_70000_1_.func_76472_a("world[" + n + "][chunks_loaded]", worldServer.func_72863_F().func_73152_e());
            ++n;
        }
        p_70000_1_.func_76472_a("worlds", n);
    }

    @Override
    public void func_70001_b(PlayerUsageSnooper p_70001_1_) {
        p_70001_1_.func_76472_a("singleplayer", this.func_71264_H());
        p_70001_1_.func_76472_a("server_brand", this.getServerModName());
        p_70001_1_.func_76472_a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        p_70001_1_.func_76472_a("dedicated", this.func_71262_S());
    }

    @Override
    public boolean func_70002_Q() {
        return true;
    }

    public int func_71227_R() {
        return 16;
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean p_71229_1_) {
        this.field_71325_x = p_71229_1_;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean p_71251_1_) {
        this.field_71324_y = p_71251_1_;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public void func_71257_f(boolean p_71257_1_) {
        this.field_71323_z = p_71257_1_;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean p_71188_1_) {
        this.field_71284_A = p_71188_1_;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean p_71245_1_) {
        this.field_71285_B = p_71245_1_;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String p_71205_1_) {
        this.field_71286_C = p_71205_1_;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int p_71191_1_) {
        this.field_71280_D = p_71191_1_;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public ServerConfigurationManager func_71203_ab() {
        return this.field_71318_t;
    }

    public void func_71210_a(ServerConfigurationManager p_71210_1_) {
        this.field_71318_t = p_71210_1_;
    }

    public void func_71235_a(EnumGameType p_71235_1_) {
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            MinecraftServer.func_71276_C().field_71305_c[i].func_72912_H().func_76060_a(p_71235_1_);
        }
    }

    public abstract NetworkListenThread func_71212_ac();

    @SideOnly(value=Side.CLIENT)
    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract String func_71206_a(EnumGameType var1, boolean var2);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    @SideOnly(value=Side.CLIENT)
    public PlayerUsageSnooper func_80003_ah() {
        return this.field_71307_n;
    }

    @Override
    public ChunkCoordinates func_82114_b() {
        return new ChunkCoordinates(0, 0, 0);
    }

    @Override
    public World func_130014_f_() {
        return this.field_71305_c[0];
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_96290_a(World p_96290_1_, int p_96290_2_, int p_96290_3_, int p_96290_4_, EntityPlayer p_96290_5_) {
        return false;
    }

    @Override
    public abstract ILogAgent func_98033_al();

    public void func_104055_i(boolean p_104055_1_) {
        this.field_104057_T = p_104055_1_;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public Proxy func_110454_ao() {
        return this.field_110456_c;
    }

    public static long func_130071_aq() {
        return System.currentTimeMillis();
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int p_143006_1_) {
        this.field_143008_E = p_143006_1_;
    }

    public static /* synthetic */ ServerConfigurationManager func_71196_a(MinecraftServer p_71196_0_) {
        return p_71196_0_.field_71318_t;
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] p_main_0_) {
        StatList.func_75919_a();
        ILogAgent iLogAgent = null;
        try {
            boolean bl = !GraphicsEnvironment.isHeadless();
            String string = null;
            String string2 = ".";
            String string3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = -1;
            for (int i = 0; i < p_main_0_.length; ++i) {
                String string4 = p_main_0_[i];
                String string5 = i == p_main_0_.length - 1 ? null : p_main_0_[i + 1];
                boolean bl4 = false;
                if (string4.equals("nogui") || string4.equals("--nogui")) {
                    bl = false;
                } else if (string4.equals("--port") && string5 != null) {
                    bl4 = true;
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string4.equals("--singleplayer") && string5 != null) {
                    bl4 = true;
                    string = string5;
                } else if (string4.equals("--universe") && string5 != null) {
                    bl4 = true;
                    string2 = string5;
                } else if (string4.equals("--world") && string5 != null) {
                    bl4 = true;
                    string3 = string5;
                } else if (string4.equals("--demo")) {
                    bl2 = true;
                } else if (string4.equals("--bonusChest")) {
                    bl3 = true;
                }
                if (!bl4) continue;
                ++i;
            }
            DedicatedServer dedicatedServer = new DedicatedServer(new File(string2));
            iLogAgent = dedicatedServer.func_98033_al();
            if (string != null) {
                dedicatedServer.func_71224_l(string);
            }
            if (string3 != null) {
                dedicatedServer.func_71261_m(string3);
            }
            if (n >= 0) {
                dedicatedServer.func_71208_b(n);
            }
            if (bl2) {
                dedicatedServer.func_71204_b(true);
            }
            if (bl3) {
                dedicatedServer.func_71194_c(true);
            }
            if (bl) {
                dedicatedServer.func_120011_ar();
            }
            dedicatedServer.func_71256_s();
            Runtime.getRuntime().addShutdownHook(new ThreadDedicatedServer(dedicatedServer));
        }
        catch (Exception exception) {
            if (iLogAgent != null) {
                iLogAgent.func_98234_c("Failed to start the minecraft server", exception);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }
}

