/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.util.Arrays;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.item.ItemStack;

public class BagStorage
implements IBitBag {
    public static final int BAG_STORAGE_SLOTS = 63;
    protected ItemStack stack;
    protected int[] contents;

    protected void setStorage(int[] source) {
        this.contents = source;
    }

    public void onChange() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof BagStorage) {
            return Arrays.equals(this.contents, ((BagStorage)obj).contents);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public int getSlots() {
        return 63;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 63) {
            int slotQty = this.contents[2 * slot + 1];
            int slotId = this.contents[2 * slot + 0];
            if (slotId != 0 && slotQty > 0) {
                return ItemChiseledBit.createStack(slotId, slotQty, false);
            }
        }
        return ModUtil.getEmptyStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot >= 0 && slot < 63 && !ModUtil.isEmpty(stack)) {
            int indexId = 2 * slot + 0;
            int indexQty = 2 * slot + 1;
            int slotId = this.contents[indexId];
            int slotQty = slotId == 0 ? 0 : this.contents[indexQty];
            ItemType type = ChiselsAndBits.getApi().getItemType(stack);
            if (type == ItemType.CHISLED_BIT) {
                try {
                    IBitBrush brush = ChiselsAndBits.getApi().createBrush(stack);
                    if (brush.getStateID() == slotId || slotId == 0) {
                        int newTotal = slotQty + ModUtil.getStackSize(stack);
                        int overFlow = newTotal > this.getBitbagStackSize() ? newTotal - this.getBitbagStackSize() : 0;
                        newTotal -= overFlow;
                        if (!simulate) {
                            this.contents[indexId] = brush.getStateID();
                            this.contents[indexQty] = newTotal;
                            this.onChange();
                        }
                        if (overFlow > 0) {
                            return ItemChiseledBit.createStack(brush.getStateID(), overFlow, false);
                        }
                        return ModUtil.getEmptyStack();
                    }
                }
                catch (APIExceptions.InvalidBitItem e) {
                    Log.logError("Something went wrong", e);
                }
            }
        }
        return stack;
    }

    @Override
    public int getBitbagStackSize() {
        return ChiselsAndBits.getConfig().bagStackSize;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= 0 && slot < 63) {
            int extracted;
            int indexId = 2 * slot + 0;
            int indexQty = 2 * slot + 1;
            int slotId = this.contents[indexId];
            int slotQty = slotId == 0 ? 0 : this.contents[indexQty];
            int n = extracted = slotQty >= amount ? amount : slotQty;
            if (extracted > 0) {
                if (!simulate) {
                    int n2 = indexQty;
                    this.contents[n2] = this.contents[n2] - extracted;
                    if (this.contents[indexQty] <= 0) {
                        this.contents[indexId] = 0;
                    }
                    this.onChange();
                }
                return ItemChiseledBit.createStack(slotId, extracted, false);
            }
        }
        return ModUtil.getEmptyStack();
    }

    @Override
    public int getSlotsUsed() {
        int used = 0;
        for (int index = 0; index < this.contents.length; index += 2) {
            int slotQty = this.contents[index + 1];
            int slotId = this.contents[index + 0];
            if (slotQty <= 0 || slotId <= 0) continue;
            ++used;
        }
        return used;
    }

    public int getSlotLimit(int slot) {
        return this.getBitbagStackSize();
    }
}

