/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import mod.chiselsandbits.chiseledblock.serialization.BitStream;
import mod.chiselsandbits.chiseledblock.serialization.BlobSerializer;
import mod.chiselsandbits.chiseledblock.serialization.BlobSerilizationCache;
import mod.chiselsandbits.chiseledblock.serialization.CrossWorldBlobSerializer;
import mod.chiselsandbits.chiseledblock.serialization.CrossWorldBlobSerializerLegacy;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class VoxelBlob
implements IVoxelSrc {
    private static final BitSet fluidFilterState = new BitSet(256);
    private static final Map<BlockRenderLayer, BitSet> layerFilters = FMLCommonHandler.instance().getSide() == Side.CLIENT ? new EnumMap<BlockRenderLayer, BitSet>(BlockRenderLayer.class) : null;
    static final int SHORT_BYTES = 2;
    public static final int dim = 16;
    public static final int dim2 = 256;
    public static final int full_size = 4096;
    public static final int dim_minus_one = 15;
    private static final int array_size = 4096;
    public static VoxelBlob NULL_BLOB;
    private final int[] values = new int[4096];
    public int detail = 16;
    public static final int VERSION_ANY = -1;
    public static final int VERSION_COMPACT = 0;
    public static final int VERSION_CROSSWORLD_LEGACY = 1;
    public static final int VERSION_CROSSWORLD = 2;
    static int bestBufferSize;

    public static synchronized void clearCache() {
        fluidFilterState.clear();
        for (Block block : Block.field_149771_c) {
            int blockId = Block.field_149771_c.func_148757_b((Object)block);
            if (BlockBitInfo.getFluidFromBlock(block) == null) continue;
            fluidFilterState.set(blockId);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            VoxelBlob.updateCacheClient();
            ModUtil.cacheFastStates();
        }
    }

    private static void updateCacheClient() {
        BlockRenderLayer[] layers;
        layerFilters.clear();
        Map<BlockRenderLayer, BitSet> layerFilters = VoxelBlob.layerFilters;
        for (BlockRenderLayer layer : layers = BlockRenderLayer.values()) {
            layerFilters.put(layer, new BitSet(4096));
        }
        for (Block block : Block.field_149771_c) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                int id = ModUtil.getStateId(state);
                if (state == null || state.func_177230_c() != block) continue;
                for (BlockRenderLayer layer : layers) {
                    if (!block.canRenderInLayer(state, layer)) continue;
                    layerFilters.get(layer).set(id);
                }
            }
        }
    }

    public VoxelBlob() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof VoxelBlob) {
            VoxelBlob a = (VoxelBlob)obj;
            return Arrays.equals(a.values, this.values);
        }
        return false;
    }

    public VoxelBlob(VoxelBlob vb) {
        for (int x = 0; x < this.values.length; ++x) {
            this.values[x] = vb.values[x];
        }
    }

    public boolean canMerge(VoxelBlob second) {
        int[] sv = second.values;
        for (int x = 0; x < this.values.length; ++x) {
            if (this.values[x] == 0 || sv[x] == 0) continue;
            return false;
        }
        return true;
    }

    public VoxelBlob merge(VoxelBlob second) {
        VoxelBlob out = new VoxelBlob();
        int[] secondValues = second.values;
        int[] ov = out.values;
        for (int x = 0; x < this.values.length; ++x) {
            int firstValue = this.values[x];
            ov[x] = firstValue == 0 ? secondValues[x] : firstValue;
        }
        return out;
    }

    public VoxelBlob mirror(EnumFacing.Axis axis) {
        VoxelBlob out = new VoxelBlob();
        BitIterator bi = new BitIterator();
        block5: while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            switch (axis) {
                case X: {
                    out.set(15 - bi.x, bi.y, bi.z, bi.getNext(this));
                    continue block5;
                }
                case Y: {
                    out.set(bi.x, 15 - bi.y, bi.z, bi.getNext(this));
                    continue block5;
                }
                case Z: {
                    out.set(bi.x, bi.y, 15 - bi.z, bi.getNext(this));
                    continue block5;
                }
            }
            throw new NullPointerException();
        }
        return out;
    }

    public BlockPos getCenter() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            if (found) {
                min_x = Math.min(min_x, bi.x);
                min_y = Math.min(min_y, bi.y);
                min_z = Math.min(min_z, bi.z);
                max_x = Math.max(max_x, bi.x);
                max_y = Math.max(max_y, bi.y);
                max_z = Math.max(max_z, bi.z);
                continue;
            }
            found = true;
            min_x = bi.x;
            min_y = bi.y;
            min_z = bi.z;
            max_x = bi.x;
            max_y = bi.y;
            max_z = bi.z;
        }
        return found ? new BlockPos((min_x + max_x) / 2, (min_y + max_y) / 2, (min_z + max_z) / 2) : null;
    }

    public IntegerBox getBounds() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            if (found) {
                min_x = Math.min(min_x, bi.x);
                min_y = Math.min(min_y, bi.y);
                min_z = Math.min(min_z, bi.z);
                max_x = Math.max(max_x, bi.x);
                max_y = Math.max(max_y, bi.y);
                max_z = Math.max(max_z, bi.z);
                continue;
            }
            found = true;
            min_x = bi.x;
            min_y = bi.y;
            min_z = bi.z;
            max_x = bi.x;
            max_y = bi.y;
            max_z = bi.z;
        }
        return found ? new IntegerBox(min_x, min_y, min_z, max_x, max_y, max_z) : null;
    }

    public VoxelBlob spin(EnumFacing.Axis axis) {
        VoxelBlob d = new VoxelBlob();
        BitIterator bi = new BitIterator();
        block5: while (bi.hasNext()) {
            switch (axis) {
                case X: {
                    d.set(bi.x, 15 - bi.z, bi.y, bi.getNext(this));
                    continue block5;
                }
                case Y: {
                    d.set(bi.z, bi.y, 15 - bi.x, bi.getNext(this));
                    continue block5;
                }
                case Z: {
                    d.set(15 - bi.y, bi.x, bi.z, bi.getNext(this));
                    continue block5;
                }
            }
            throw new NullPointerException();
        }
        return d;
    }

    public void fill(int value) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = value;
        }
    }

    public void fill(VoxelBlob src) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = src.values[x];
        }
    }

    public void clear() {
        this.fill(0);
    }

    public int air() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] != 0) continue;
            ++p;
        }
        return p;
    }

    public void binaryReplacement(int airReplacement, int solidReplacement) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = this.values[x] == 0 ? airReplacement : solidReplacement;
        }
    }

    public int filled() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] == 0) continue;
            ++p;
        }
        return p;
    }

    protected int getBit(int offset) {
        return this.values[offset];
    }

    protected void putBit(int offset, int newValue) {
        this.values[offset] = newValue;
    }

    public int get(int x, int y, int z) {
        return this.getBit(x | y << 4 | z << 8);
    }

    public VoxelType getVoxelType(int x, int y, int z) {
        return BlockBitInfo.getTypeFromStateID(this.get(x, y, z));
    }

    public void set(int x, int y, int z, int value) {
        this.putBit(x | y << 4 | z << 8, value);
    }

    public void clear(int x, int y, int z) {
        this.putBit(x | y << 4 | z << 8, 0);
    }

    private void legacyRead(ByteArrayInputStream o) throws IOException {
        GZIPInputStream w = new GZIPInputStream(o);
        ByteBuffer bb = ByteBuffer.allocate(this.values.length * 2);
        w.read(bb.array());
        ShortBuffer src = bb.asShortBuffer();
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = this.fixShorts(src.get());
        }
        w.close();
    }

    private int fixShorts(short s) {
        return s & 0xFFFF;
    }

    private void legacyWrite(ByteArrayOutputStream o) {
        try {
            GZIPOutputStream w = new GZIPOutputStream(o);
            ByteBuffer bb = ByteBuffer.allocate(this.values.length * 2);
            ShortBuffer sb = bb.asShortBuffer();
            for (int x = 0; x < 4096; ++x) {
                sb.put((short)this.values[x]);
            }
            w.write(bb.array());
            w.finish();
            w.close();
            o.close();
        }
        catch (IOException e) {
            Log.logError("Unable to write blob.", e);
            throw new RuntimeException(e);
        }
    }

    public byte[] toLegacyByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.legacyWrite(out);
        return out.toByteArray();
    }

    public void fromLegacyByteArray(byte[] i) throws IOException {
        ByteArrayInputStream out = new ByteArrayInputStream(i);
        this.legacyRead(out);
    }

    @Override
    public int getSafe(int x, int y, int z) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16 && z >= 0 && z < 16) {
            return this.get(x, y, z);
        }
        return 0;
    }

    public void visibleFace(EnumFacing face, int x, int y, int z, VisibleFace dest, VoxelBlob secondBlob, ICullTest cullVisTest) {
        int mySpot;
        dest.state = mySpot = this.get(x, y, z);
        if ((x += face.func_82601_c()) >= 0 && x < 16 && (y += face.func_96559_d()) >= 0 && y < 16 && (z += face.func_82599_e()) >= 0 && z < 16) {
            dest.isEdge = false;
            dest.visibleFace = cullVisTest.isVisible(mySpot, this.get(x, y, z));
        } else if (secondBlob != null) {
            dest.isEdge = true;
            dest.visibleFace = cullVisTest.isVisible(mySpot, secondBlob.get(x - face.func_82601_c() * 16, y - face.func_96559_d() * 16, z - face.func_82599_e() * 16));
        } else {
            dest.isEdge = true;
            dest.visibleFace = mySpot != 0;
        }
    }

    public Map<Integer, Integer> getBlockSums() {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        int lastType = this.values[0];
        int firstOfType = 0;
        for (int x = 1; x < 4096; ++x) {
            int v = this.values[x];
            if (lastType == v) continue;
            Integer sumx = (Integer)counts.get(lastType);
            if (sumx == null) {
                counts.put(lastType, x - firstOfType);
            } else {
                counts.put(lastType, sumx + (x - firstOfType));
            }
            firstOfType = x;
            lastType = v;
        }
        Integer sumx = (Integer)counts.get(lastType);
        if (sumx == null) {
            counts.put(lastType, 4096 - firstOfType);
        } else {
            counts.put(lastType, sumx + (4096 - firstOfType));
        }
        return counts;
    }

    public List<TypeRef> getBlockCounts() {
        Map<Integer, Integer> count = this.getBlockSums();
        ArrayList<TypeRef> out = new ArrayList<TypeRef>(count.size());
        for (Map.Entry<Integer, Integer> o : count.entrySet()) {
            out.add(new TypeRef(o.getKey(), o.getValue()));
        }
        return out;
    }

    public BlobStats getVoxelStats() {
        BlobStats cb = new BlobStats();
        cb.isNormalBlock = true;
        int nonAirBits = 0;
        for (Map.Entry<Integer, Integer> o : this.getBlockSums().entrySet()) {
            IBlockState state;
            int quantity = o.getValue();
            int r = o.getKey();
            if (quantity > cb.mostCommonStateTotal && r != 0) {
                cb.mostCommonState = r;
                cb.mostCommonStateTotal = quantity;
            }
            if ((state = ModUtil.getStateById(r)) == null || r == 0) continue;
            nonAirBits += quantity;
            cb.isNormalBlock = cb.isNormalBlock && ModUtil.isNormalCube(state);
            cb.blockLight += (float)(quantity * DeprecationHelper.getLightValue(state));
        }
        cb.isFullBlock = cb.mostCommonStateTotal == 4096;
        cb.isNormalBlock = cb.isNormalBlock && 4096 == nonAirBits;
        float light_size = ChiselsAndBits.getConfig().bitLightPercentage * 4096.0f * 15.0f / 100.0f;
        cb.blockLight /= light_size;
        return cb;
    }

    public VoxelBlob offset(int xx, int yy, int zz) {
        VoxelBlob out = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    out.set(x, y, z, this.getSafe(x - xx, y - yy, z - zz));
                }
            }
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> listContents(List<String> details) {
        HashMap<Integer, Integer> states = new HashMap<Integer, Integer>();
        HashMap<String, Integer> contents = new HashMap<String, Integer>();
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            int state = bi.getNext(this);
            if (state == 0) continue;
            Integer count = (Integer)states.get(state);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            states.put(state, count);
        }
        for (Map.Entry e : states.entrySet()) {
            String name = ItemChiseledBit.getBitTypeName(ItemChiseledBit.createStack((Integer)e.getKey(), 1, false));
            if (name == null) continue;
            Integer count = (Integer)contents.get(name);
            count = count == null ? (Integer)e.getValue() : Integer.valueOf(count + (Integer)e.getValue());
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add(LocalStrings.Empty.getLocal());
        }
        for (Map.Entry e : contents.entrySet()) {
            details.add(e.getValue() + ' ' + (String)e.getKey());
        }
        return details;
    }

    public int getSideFlags(int minRange, int maxRange, int totalRequired) {
        int output = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int edge = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 15 : 0;
            int required = totalRequired;
            switch (face.func_176740_k()) {
                case X: {
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (int y = minRange; y <= maxRange; ++y) {
                            if (this.getVoxelType(edge, y, z) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Y: {
                    int x;
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.getVoxelType(x, edge, z) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Z: {
                    int x;
                    for (int y = minRange; y <= maxRange; ++y) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.getVoxelType(x, y, edge) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            if (required > 0) continue;
            output |= 1 << face.ordinal();
        }
        return output;
    }

    public static boolean isFluid(int ref) {
        return fluidFilterState.get(ref & 0xFFF);
    }

    public boolean filterFluids(boolean wantsFluids) {
        boolean hasValues = false;
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            if (ref == 0) continue;
            if (fluidFilterState.get(ref & 0xFFF) != wantsFluids) {
                this.values[x] = 0;
                continue;
            }
            hasValues = true;
        }
        return hasValues;
    }

    public boolean filter(BlockRenderLayer layer) {
        BitSet layerFilterState = layerFilters.get(layer);
        boolean hasValues = false;
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            if (ref == 0) continue;
            if (!layerFilterState.get(ref)) {
                this.values[x] = 0;
                continue;
            }
            hasValues = true;
        }
        return hasValues;
    }

    public void blobFromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream out = new ByteArrayInputStream(bytes);
        this.read(out);
    }

    private void read(ByteArrayInputStream o) throws IOException, RuntimeException {
        InflaterInputStream w = new InflaterInputStream(o);
        ByteBuffer bb = BlobSerilizationCache.getCacheBuffer();
        int usedBytes = 0;
        int rv = 0;
        while ((rv = w.read(bb.array(), usedBytes += rv, bb.limit() - usedBytes)) > 0) {
        }
        PacketBuffer header = new PacketBuffer(Unpooled.wrappedBuffer((ByteBuffer)bb));
        int version = header.func_150792_a();
        BlobSerializer bs = null;
        if (version == 0) {
            bs = new BlobSerializer(header);
        } else if (version == 1) {
            bs = new CrossWorldBlobSerializerLegacy(header);
        } else if (version == 2) {
            bs = new CrossWorldBlobSerializer(header);
        } else {
            throw new RuntimeException("Invalid Version: " + version);
        }
        int byteOffset = header.func_150792_a();
        int bytesOfInterest = header.func_150792_a();
        BitStream bits = BitStream.valueOf(byteOffset, ByteBuffer.wrap(bb.array(), header.readerIndex(), bytesOfInterest));
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = bs.readVoxelStateID(bits);
        }
        w.close();
    }

    public byte[] blobToBytes(int version) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(bestBufferSize);
        this.write(out, this.getSerializer(version));
        byte[] o = out.toByteArray();
        if (bestBufferSize < o.length) {
            bestBufferSize = o.length;
        }
        return o;
    }

    private BlobSerializer getSerializer(int version) {
        if (version == 0) {
            return new BlobSerializer(this);
        }
        if (version == 1) {
            return new CrossWorldBlobSerializerLegacy(this);
        }
        if (version == 2) {
            return new CrossWorldBlobSerializer(this);
        }
        throw new RuntimeException("Invalid Version: " + version);
    }

    private void write(ByteArrayOutputStream o, BlobSerializer bs) {
        try {
            Deflater def = BlobSerilizationCache.getCacheDeflater();
            DeflaterOutputStream w = new DeflaterOutputStream((OutputStream)o, def, bestBufferSize);
            PacketBuffer pb = BlobSerilizationCache.getCachePacketBuffer();
            pb.func_150787_b(bs.getVersion());
            bs.write(pb);
            BitStream set = BlobSerilizationCache.getCacheBitStream();
            for (int x = 0; x < 4096; ++x) {
                bs.writeVoxelState(this.values[x], set);
            }
            byte[] arrayContents = set.toByteArray();
            int bytesToWrite = arrayContents.length;
            int byteOffset = set.byteOffset();
            pb.func_150787_b(byteOffset);
            pb.func_150787_b(bytesToWrite - byteOffset);
            w.write(pb.array(), 0, pb.writerIndex());
            w.write(arrayContents, byteOffset, bytesToWrite - byteOffset);
            w.finish();
            w.close();
            def.reset();
            o.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        VoxelBlob.clearCache();
        NULL_BLOB = new VoxelBlob();
        bestBufferSize = 26;
    }

    public static class TypeRef {
        public final int stateId;
        public int quantity;

        public TypeRef(int id, int q) {
            this.stateId = id;
            this.quantity = q;
        }
    }

    public static class BlobStats {
        public int mostCommonState;
        public int mostCommonStateTotal;
        public boolean isFullBlock;
        public float blockLight;
        public boolean isNormalBlock;
    }

    public static class VisibleFace {
        public boolean isEdge;
        public boolean visibleFace;
        public int state;
    }
}

